/*
 * Decompiled with CFR 0.152.
 */
package btclientalpha;

import btclientalpha.BTClientALPHAAboutBox;
import btclientalpha.BTClientALPHAApp;
import btclientalpha.DieGenerator;
import btclientalpha.GameCanvas;
import btclientalpha.MechSelectorDialog;
import btclientalpha.PhaseEngine;
import btclientalpha.PlayerMech;
import btclientalpha.mech.MechBody;
import btclientalpha.mech.MechJenner;
import btclientalpha.mech.weapons.Weapon;
import java.awt.Canvas;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;

public class BTClientALPHAView
extends FrameView {
    private JLabel CanvasStatusLabel;
    private JButton PhaseChange;
    private JLabel PhaseLabel;
    private JLabel PhaseStatus;
    private JLabel PlayerLabel;
    private JLabel PlayerNameLabel;
    private Canvas canvas1;
    private JLabel centerTorsoArmorLabel;
    private JLabel centerTorsoLabel;
    private JLabel centerTorsoRearArmorLabel;
    private JLabel diceRollResult;
    private JLabel headArmorLabel;
    private JLabel headLabel;
    private JLabel heatLabel;
    private JLabel heatLevelValue;
    private JButton jButton1;
    private JFrame jFrame1;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JLabel leftArmArmorLabel;
    private JLabel leftLegArmorLabel;
    private JLabel leftLegLabel;
    private JLabel leftTorsoArmorLabel;
    private JLabel leftTorsoLabel;
    private JLabel leftTorsoRearArmorLabel;
    private JLabel leftrmLabel;
    private JPanel mainPanel;
    private JLabel mechLabel;
    private JLabel mechNameLabel;
    private JMenuBar menuBar;
    private JLabel moveAvailLabel;
    private JLabel moveAvailValueLabel;
    private JLabel moveModLabel;
    private JLabel moveModValueLabel;
    private JLabel moveRunLabel;
    private JLabel moveRunValueLabel;
    private JLabel moveWalkLabel;
    private JLabel moveWalkValueLabel;
    private JLabel movementLabel;
    private JPanel movementPanel;
    private JPanel playerStatusPanel;
    private JProgressBar progressBar;
    private JLabel rightArmArmorLabel;
    private JLabel rightArmLabel;
    private JLabel rightLegArmorLabel;
    private JLabel rightLegLabel;
    private JLabel rightTorsoArmorLabel;
    private JLabel rightTorsoLabel;
    private JLabel rightTorsoRearArmorLabel;
    private JButton rollDiceBtn;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JLabel tonnageLabel;
    private JLabel tonnageValueLabel;
    private JLabel torsoTwistLabel;
    private JButton torsoTwistLeftBtn;
    private JPanel torsoTwistPanel;
    private JButton torsoTwistRightBtn;
    private JLabel weapon1AmmoValue;
    private JLabel weapon1Label;
    private JLabel weapon2AmmoValue;
    private JLabel weapon2Label;
    private JLabel weapon3AmmoValue;
    private JLabel weapon3Label;
    private JLabel weapon4AmmoValue;
    private JLabel weapon4Label;
    private JLabel weapon5AmmoValue;
    private JLabel weapon5Label;
    private JButton wep1Btn;
    private JButton wep2Btn;
    private JButton wep3Btn;
    private JButton wep4Btn;
    private JButton wep5Btn;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;
    private MechSelectorDialog mechSelector;
    private GameCanvas tempCanvas;
    private DieGenerator dice = new DieGenerator();
    private PhaseEngine phase = new PhaseEngine();
    private PlayerMech pm1 = new PlayerMech(1, "Steven", 1);
    private PlayerMech pm2;
    private int moves = 0;

    public BTClientALPHAView(SingleFrameApplication app) {
        super(app);
        this.pm1.setMech(new MechJenner(), 0);
        this.initComponents();
        this.tempCanvas = (GameCanvas)this.canvas1;
        this.uiUpdate();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BTClientALPHAView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BTClientALPHAView.this.busyIconIndex = (BTClientALPHAView.this.busyIconIndex + 1) % BTClientALPHAView.this.busyIcons.length;
                BTClientALPHAView.this.statusAnimationLabel.setIcon(BTClientALPHAView.this.busyIcons[BTClientALPHAView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!BTClientALPHAView.this.busyIconTimer.isRunning()) {
                        BTClientALPHAView.this.statusAnimationLabel.setIcon(BTClientALPHAView.this.busyIcons[0]);
                        BTClientALPHAView.this.busyIconIndex = 0;
                        BTClientALPHAView.this.busyIconTimer.start();
                    }
                    BTClientALPHAView.this.progressBar.setVisible(true);
                    BTClientALPHAView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    BTClientALPHAView.this.busyIconTimer.stop();
                    BTClientALPHAView.this.statusAnimationLabel.setIcon(BTClientALPHAView.this.idleIcon);
                    BTClientALPHAView.this.progressBar.setVisible(false);
                    BTClientALPHAView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    BTClientALPHAView.this.statusMessageLabel.setText(text == null ? "" : text);
                    BTClientALPHAView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    BTClientALPHAView.this.progressBar.setVisible(true);
                    BTClientALPHAView.this.progressBar.setIndeterminate(false);
                    BTClientALPHAView.this.progressBar.setValue(value);
                }
            }
        });
    }

    public void showMechSelector() {
        if (this.mechSelector == null) {
            JFrame mainFrame = BTClientALPHAApp.getApplication().getMainFrame();
            this.mechSelector = new MechSelectorDialog((Frame)mainFrame, true);
            this.mechSelector.setLocationRelativeTo(mainFrame);
        }
        BTClientALPHAApp.getApplication().show(this.mechSelector);
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = BTClientALPHAApp.getApplication().getMainFrame();
            this.aboutBox = new BTClientALPHAAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        BTClientALPHAApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.movementPanel = new JPanel();
        this.movementLabel = new JLabel();
        this.moveWalkLabel = new JLabel();
        this.moveRunLabel = new JLabel();
        this.moveModLabel = new JLabel();
        this.moveAvailLabel = new JLabel();
        this.moveWalkValueLabel = new JLabel();
        this.moveRunValueLabel = new JLabel();
        this.moveModValueLabel = new JLabel();
        this.moveAvailValueLabel = new JLabel();
        this.playerStatusPanel = new JPanel();
        this.PlayerLabel = new JLabel();
        this.PlayerNameLabel = new JLabel();
        this.mechLabel = new JLabel();
        this.mechNameLabel = new JLabel();
        this.tonnageLabel = new JLabel();
        this.tonnageValueLabel = new JLabel();
        this.headLabel = new JLabel();
        this.leftLegLabel = new JLabel();
        this.leftrmLabel = new JLabel();
        this.leftTorsoLabel = new JLabel();
        this.centerTorsoLabel = new JLabel();
        this.rightTorsoLabel = new JLabel();
        this.rightArmLabel = new JLabel();
        this.rightLegLabel = new JLabel();
        this.headArmorLabel = new JLabel();
        this.leftLegArmorLabel = new JLabel();
        this.leftArmArmorLabel = new JLabel();
        this.leftTorsoArmorLabel = new JLabel();
        this.leftTorsoRearArmorLabel = new JLabel();
        this.centerTorsoArmorLabel = new JLabel();
        this.centerTorsoRearArmorLabel = new JLabel();
        this.rightTorsoArmorLabel = new JLabel();
        this.rightTorsoRearArmorLabel = new JLabel();
        this.rightArmArmorLabel = new JLabel();
        this.rightLegArmorLabel = new JLabel();
        this.heatLabel = new JLabel();
        this.heatLevelValue = new JLabel();
        this.weapon1Label = new JLabel();
        this.weapon1AmmoValue = new JLabel();
        this.weapon2Label = new JLabel();
        this.weapon2AmmoValue = new JLabel();
        this.weapon3Label = new JLabel();
        this.weapon3AmmoValue = new JLabel();
        this.weapon4Label = new JLabel();
        this.weapon4AmmoValue = new JLabel();
        this.weapon5Label = new JLabel();
        this.weapon5AmmoValue = new JLabel();
        this.wep5Btn = new JButton();
        this.wep1Btn = new JButton();
        this.wep2Btn = new JButton();
        this.wep3Btn = new JButton();
        this.wep4Btn = new JButton();
        this.CanvasStatusLabel = new JLabel();
        this.torsoTwistPanel = new JPanel();
        this.torsoTwistLeftBtn = new JButton();
        this.torsoTwistRightBtn = new JButton();
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.PhaseChange = new JButton();
        this.rollDiceBtn = new JButton();
        this.diceRollResult = new JLabel();
        this.canvas1 = new GameCanvas(16, 33, 21);
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.PhaseLabel = new JLabel();
        this.PhaseStatus = new JLabel();
        this.torsoTwistLabel = new JLabel();
        this.jFrame1 = new JFrame();
        this.mainPanel.setMaximumSize(new Dimension(914, 480));
        this.mainPanel.setMinimumSize(new Dimension(914, 480));
        this.mainPanel.setName("mainPanel");
        this.mainPanel.setLayout(null);
        this.movementPanel.setName("movementPanel");
        ResourceMap resourceMap = Application.getInstance(BTClientALPHAApp.class).getContext().getResourceMap(BTClientALPHAView.class);
        this.movementLabel.setText(resourceMap.getString("movementLabel.text", new Object[0]));
        this.movementLabel.setName("movementLabel");
        this.moveWalkLabel.setHorizontalAlignment(4);
        this.moveWalkLabel.setText(resourceMap.getString("moveWalkLabel.text", new Object[0]));
        this.moveWalkLabel.setName("moveWalkLabel");
        this.moveRunLabel.setHorizontalAlignment(11);
        this.moveRunLabel.setText(resourceMap.getString("moveRunLabel.text", new Object[0]));
        this.moveRunLabel.setName("moveRunLabel");
        this.moveModLabel.setHorizontalAlignment(4);
        this.moveModLabel.setText(resourceMap.getString("moveModLabel.text", new Object[0]));
        this.moveModLabel.setName("moveModLabel");
        this.moveAvailLabel.setHorizontalAlignment(4);
        this.moveAvailLabel.setText(resourceMap.getString("moveAvailLabel.text", new Object[0]));
        this.moveAvailLabel.setName("moveAvailLabel");
        this.moveWalkValueLabel.setText(resourceMap.getString("moveWalkValueLabel.text", new Object[0]));
        this.moveWalkValueLabel.setName("moveWalkValueLabel");
        this.moveRunValueLabel.setText(resourceMap.getString("moveRunValueLabel.text", new Object[0]));
        this.moveRunValueLabel.setName("moveRunValueLabel");
        this.moveModValueLabel.setText(resourceMap.getString("moveModValueLabel.text", new Object[0]));
        this.moveModValueLabel.setName("moveModValueLabel");
        this.moveAvailValueLabel.setText(resourceMap.getString("moveAvailValueLabel.text", new Object[0]));
        this.moveAvailValueLabel.setName("moveAvailValueLabel");
        GroupLayout movementPanelLayout = new GroupLayout(this.movementPanel);
        this.movementPanel.setLayout(movementPanelLayout);
        movementPanelLayout.setHorizontalGroup(movementPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(movementPanelLayout.createSequentialGroup().addGroup(movementPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(movementPanelLayout.createSequentialGroup().addGap(20, 20, 20).addGroup(movementPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.moveWalkLabel, GroupLayout.Alignment.TRAILING).addComponent(this.moveRunLabel, GroupLayout.Alignment.TRAILING).addComponent(this.moveModLabel, GroupLayout.Alignment.TRAILING).addComponent(this.moveAvailLabel, GroupLayout.Alignment.TRAILING)).addGap(3, 3, 3).addGroup(movementPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.moveWalkValueLabel).addComponent(this.moveRunValueLabel).addComponent(this.moveModValueLabel).addComponent(this.moveAvailValueLabel))).addGroup(movementPanelLayout.createSequentialGroup().addGap(50, 50, 50).addComponent(this.movementLabel))).addGap(26, 26, 26)));
        movementPanelLayout.setVerticalGroup(movementPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(movementPanelLayout.createSequentialGroup().addComponent(this.movementLabel).addGap(6, 6, 6).addGroup(movementPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.moveWalkLabel).addComponent(this.moveWalkValueLabel)).addGap(6, 6, 6).addGroup(movementPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.moveRunLabel).addComponent(this.moveRunValueLabel)).addGap(6, 6, 6).addGroup(movementPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.moveModLabel).addComponent(this.moveModValueLabel)).addGap(6, 6, 6).addGroup(movementPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.moveAvailLabel).addComponent(this.moveAvailValueLabel))));
        this.movementPanel.setVisible(false);
        this.mainPanel.add(this.movementPanel);
        this.movementPanel.setBounds(40, 500, 123, 94);
        this.playerStatusPanel.setBorder(BorderFactory.createEtchedBorder(0, resourceMap.getColor("playerStatusPanel.border.highlightColor"), resourceMap.getColor("playerStatusPanel.border.shadowColor")));
        this.playerStatusPanel.setName("playerStatusPanel");
        this.PlayerLabel.setName("PlayerLabel");
        this.PlayerNameLabel.setText(this.pm1.getPlayerName());
        this.PlayerNameLabel.setName("PlayerNameLabel");
        this.mechLabel.setText(resourceMap.getString("mechLabel.text", new Object[0]));
        this.mechLabel.setName("mechLabel");
        this.mechNameLabel.setText(this.pm1.getMechName(0));
        this.mechNameLabel.setName("mechNameLabel");
        this.tonnageLabel.setText(resourceMap.getString("tonnageLabel.text", new Object[0]));
        this.tonnageLabel.setName("tonnageLabel");
        this.tonnageValueLabel.setText(Double.toString(this.pm1.getMech(0).currentBuildTonnage()));
        this.tonnageValueLabel.setName("tonnageValueLabel");
        this.headLabel.setText(resourceMap.getString("headLabel.text", new Object[0]));
        this.headLabel.setName("headLabel");
        this.leftLegLabel.setText(resourceMap.getString("leftLegLabel.text", new Object[0]));
        this.leftLegLabel.setName("leftLegLabel");
        this.leftrmLabel.setText(resourceMap.getString("leftrmLabel.text", new Object[0]));
        this.leftrmLabel.setName("leftrmLabel");
        this.leftTorsoLabel.setText(resourceMap.getString("leftTorsoLabel.text", new Object[0]));
        this.leftTorsoLabel.setName("leftTorsoLabel");
        this.centerTorsoLabel.setText(resourceMap.getString("centerTorsoLabel.text", new Object[0]));
        this.centerTorsoLabel.setName("centerTorsoLabel");
        this.rightTorsoLabel.setText(resourceMap.getString("rightTorsoLabel.text", new Object[0]));
        this.rightTorsoLabel.setName("rightTorsoLabel");
        this.rightArmLabel.setText(resourceMap.getString("rightArmLabel.text", new Object[0]));
        this.rightArmLabel.setName("rightArmLabel");
        this.rightLegLabel.setText(resourceMap.getString("rightLegLabel.text", new Object[0]));
        this.rightLegLabel.setName("rightLegLabel");
        this.headArmorLabel.setText(resourceMap.getString("headArmorLabel.text", new Object[0]));
        this.headArmorLabel.setName("headArmorLabel");
        this.leftLegArmorLabel.setText(resourceMap.getString("leftLegArmorLabel.text", new Object[0]));
        this.leftLegArmorLabel.setName("leftLegArmorLabel");
        this.leftArmArmorLabel.setText(resourceMap.getString("leftArmArmorLabel.text", new Object[0]));
        this.leftArmArmorLabel.setName("leftArmArmorLabel");
        this.leftTorsoArmorLabel.setText(resourceMap.getString("leftTorsoArmorLabel.text", new Object[0]));
        this.leftTorsoArmorLabel.setName("leftTorsoArmorLabel");
        this.leftTorsoRearArmorLabel.setText(resourceMap.getString("leftTorsoRearArmorLabel.text", new Object[0]));
        this.leftTorsoRearArmorLabel.setName("leftTorsoRearArmorLabel");
        this.centerTorsoArmorLabel.setText(resourceMap.getString("centerTorsoArmorLabel.text", new Object[0]));
        this.centerTorsoArmorLabel.setName("centerTorsoArmorLabel");
        this.centerTorsoRearArmorLabel.setText(resourceMap.getString("centerTorsoRearArmorLabel.text", new Object[0]));
        this.centerTorsoRearArmorLabel.setName("centerTorsoRearArmorLabel");
        this.rightTorsoArmorLabel.setText(resourceMap.getString("rightTorsoArmorLabel.text", new Object[0]));
        this.rightTorsoArmorLabel.setName("rightTorsoArmorLabel");
        this.rightTorsoRearArmorLabel.setText(resourceMap.getString("rightTorsoRearArmorLabel.text", new Object[0]));
        this.rightTorsoRearArmorLabel.setName("rightTorsoRearArmorLabel");
        this.rightArmArmorLabel.setText(resourceMap.getString("rightArmArmorLabel.text", new Object[0]));
        this.rightArmArmorLabel.setName("rightArmArmorLabel");
        this.rightLegArmorLabel.setText(resourceMap.getString("rightLegArmorLabel.text", new Object[0]));
        this.rightLegArmorLabel.setName("rightLegArmorLabel");
        this.heatLabel.setText(resourceMap.getString("heatLabel.text", new Object[0]));
        this.heatLabel.setName("heatLabel");
        this.heatLevelValue.setText(resourceMap.getString("heatLevelValue.text", new Object[0]));
        this.heatLevelValue.setName("heatLevelValue");
        this.weapon1Label.setText(resourceMap.getString("weapon1Label.text", new Object[0]));
        this.weapon1Label.setName("weapon1Label");
        this.weapon1AmmoValue.setText(resourceMap.getString("weapon1AmmoValue.text", new Object[0]));
        this.weapon1AmmoValue.setName("weapon1AmmoValue");
        this.weapon2Label.setText(resourceMap.getString("weapon2Label.text", new Object[0]));
        this.weapon2Label.setName("weapon2Label");
        this.weapon2AmmoValue.setText(resourceMap.getString("weapon2AmmoValue.text", new Object[0]));
        this.weapon2AmmoValue.setName("weapon2AmmoValue");
        this.weapon3Label.setText(resourceMap.getString("weapon3Label.text", new Object[0]));
        this.weapon3Label.setName("weapon3Label");
        this.weapon3AmmoValue.setText(resourceMap.getString("weapon3AmmoValue.text", new Object[0]));
        this.weapon3AmmoValue.setName("weapon3AmmoValue");
        this.weapon4Label.setText(resourceMap.getString("weapon4Label.text", new Object[0]));
        this.weapon4Label.setName("weapon4Label");
        this.weapon4AmmoValue.setText(resourceMap.getString("weapon4AmmoValue.text", new Object[0]));
        this.weapon4AmmoValue.setName("weapon4AmmoValue");
        this.weapon5Label.setText(resourceMap.getString("weapon5Label.text", new Object[0]));
        this.weapon5Label.setName("weapon5Label");
        this.weapon5AmmoValue.setText(resourceMap.getString("weapon5AmmoValue.text", new Object[0]));
        this.weapon5AmmoValue.setName("weapon5AmmoValue");
        this.wep5Btn.setText(resourceMap.getString("wep5Btn.text", new Object[0]));
        this.wep5Btn.setEnabled(false);
        this.wep5Btn.setName("wep5Btn");
        this.wep5Btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BTClientALPHAView.this.wep5BtnActionPerformed(evt);
            }
        });
        this.wep1Btn.setText(resourceMap.getString("wep1Btn.text", new Object[0]));
        this.wep1Btn.setEnabled(false);
        this.wep1Btn.setName("wep1Btn");
        this.wep1Btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BTClientALPHAView.this.wep1BtnActionPerformed(evt);
            }
        });
        this.wep2Btn.setText(resourceMap.getString("wep2Btn.text", new Object[0]));
        this.wep2Btn.setEnabled(false);
        this.wep2Btn.setName("wep2Btn");
        this.wep2Btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BTClientALPHAView.this.wep2BtnActionPerformed(evt);
            }
        });
        this.wep3Btn.setText(resourceMap.getString("wep3Btn.text", new Object[0]));
        this.wep3Btn.setEnabled(false);
        this.wep3Btn.setName("wep3Btn");
        this.wep3Btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BTClientALPHAView.this.wep3BtnActionPerformed(evt);
            }
        });
        this.wep4Btn.setText(resourceMap.getString("wep4Btn.text", new Object[0]));
        this.wep4Btn.setEnabled(false);
        this.wep4Btn.setName("wep4Btn");
        this.wep4Btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BTClientALPHAView.this.wep4BtnActionPerformed(evt);
            }
        });
        GroupLayout playerStatusPanelLayout = new GroupLayout(this.playerStatusPanel);
        this.playerStatusPanel.setLayout(playerStatusPanelLayout);
        playerStatusPanelLayout.setHorizontalGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(playerStatusPanelLayout.createSequentialGroup().addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(playerStatusPanelLayout.createSequentialGroup().addGap(24, 24, 24).addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.weapon5Label).addComponent(this.weapon4Label).addComponent(this.weapon3Label).addComponent(this.weapon2Label).addComponent(this.weapon1Label)).addGap(10, 10, 10).addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.weapon1AmmoValue).addComponent(this.weapon2AmmoValue).addComponent(this.weapon3AmmoValue).addComponent(this.weapon4AmmoValue).addComponent(this.weapon5AmmoValue)).addGap(11, 11, 11).addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.wep1Btn, -2, 50, -2).addComponent(this.wep2Btn, -2, 50, -2).addComponent(this.wep3Btn, -2, 50, -2).addComponent(this.wep4Btn, -2, 50, -2).addComponent(this.wep5Btn, -2, 50, -2))).addGroup(playerStatusPanelLayout.createSequentialGroup().addGap(13, 13, 13).addComponent(this.heatLabel).addGap(10, 10, 10).addComponent(this.heatLevelValue)).addGroup(playerStatusPanelLayout.createSequentialGroup().addGap(31, 31, 31).addComponent(this.rightLegLabel).addGap(10, 10, 10).addComponent(this.rightLegArmorLabel)).addGroup(playerStatusPanelLayout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.rightArmLabel).addGap(10, 10, 10).addComponent(this.rightArmArmorLabel)).addGroup(playerStatusPanelLayout.createSequentialGroup().addGap(30, 30, 30).addComponent(this.rightTorsoLabel).addGap(10, 10, 10).addComponent(this.rightTorsoArmorLabel).addGap(6, 6, 6).addComponent(this.rightTorsoRearArmorLabel)).addGroup(playerStatusPanelLayout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.centerTorsoLabel).addGap(10, 10, 10).addComponent(this.centerTorsoArmorLabel).addGap(6, 6, 6).addComponent(this.centerTorsoRearArmorLabel)).addGroup(playerStatusPanelLayout.createSequentialGroup().addGap(36, 36, 36).addComponent(this.leftTorsoLabel).addGap(10, 10, 10).addComponent(this.leftTorsoArmorLabel).addGap(6, 6, 6).addComponent(this.leftTorsoRearArmorLabel)).addGroup(playerStatusPanelLayout.createSequentialGroup().addGap(35, 35, 35).addComponent(this.leftrmLabel).addGap(10, 10, 10).addComponent(this.leftArmArmorLabel)).addGroup(playerStatusPanelLayout.createSequentialGroup().addGap(37, 37, 37).addComponent(this.leftLegLabel).addGap(10, 10, 10).addComponent(this.leftLegArmorLabel)).addGroup(playerStatusPanelLayout.createSequentialGroup().addGap(39, 39, 39).addComponent(this.headLabel).addGap(10, 10, 10).addComponent(this.headArmorLabel)).addGroup(playerStatusPanelLayout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.tonnageLabel).addGap(10, 10, 10).addComponent(this.tonnageValueLabel)).addGroup(playerStatusPanelLayout.createSequentialGroup().addGap(39, 39, 39).addComponent(this.mechLabel).addGap(10, 10, 10).addComponent(this.mechNameLabel)).addGroup(playerStatusPanelLayout.createSequentialGroup().addGap(34, 34, 34).addComponent(this.PlayerLabel).addGap(10, 10, 10).addComponent(this.PlayerNameLabel))).addContainerGap(-1, Short.MAX_VALUE)));
        playerStatusPanelLayout.setVerticalGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(playerStatusPanelLayout.createSequentialGroup().addGap(11, 11, 11).addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.PlayerLabel).addComponent(this.PlayerNameLabel)).addGap(6, 6, 6).addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mechLabel).addComponent(this.mechNameLabel)).addGap(6, 6, 6).addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tonnageLabel).addComponent(this.tonnageValueLabel)).addGap(6, 6, 6).addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headLabel).addComponent(this.headArmorLabel)).addGap(6, 6, 6).addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.leftLegLabel).addComponent(this.leftLegArmorLabel)).addGap(6, 6, 6).addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.leftrmLabel).addComponent(this.leftArmArmorLabel)).addGap(6, 6, 6).addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.leftTorsoLabel).addComponent(this.leftTorsoArmorLabel).addComponent(this.leftTorsoRearArmorLabel)).addGap(6, 6, 6).addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.centerTorsoLabel).addComponent(this.centerTorsoArmorLabel).addComponent(this.centerTorsoRearArmorLabel)).addGap(6, 6, 6).addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rightTorsoLabel).addComponent(this.rightTorsoArmorLabel).addComponent(this.rightTorsoRearArmorLabel)).addGap(6, 6, 6).addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rightArmLabel).addComponent(this.rightArmArmorLabel)).addGap(6, 6, 6).addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rightLegLabel).addComponent(this.rightLegArmorLabel)).addGap(11, 11, 11).addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.heatLabel).addComponent(this.heatLevelValue)).addGap(8, 8, 8).addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.weapon1Label).addComponent(this.weapon1AmmoValue).addComponent(this.wep1Btn, -2, 20, -2)).addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.weapon2Label).addComponent(this.weapon2AmmoValue).addComponent(this.wep2Btn, -2, 20, -2)).addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.weapon3Label).addComponent(this.weapon3AmmoValue).addComponent(this.wep3Btn, -2, 20, -2)).addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.weapon4Label).addComponent(this.weapon4AmmoValue).addComponent(this.wep4Btn, -2, 20, -2)).addGroup(playerStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.wep5Btn, -2, 20, -2).addComponent(this.weapon5AmmoValue).addComponent(this.weapon5Label)).addContainerGap(-1, Short.MAX_VALUE)));
        this.mainPanel.add(this.playerStatusPanel);
        this.playerStatusPanel.setBounds(10, 11, 182, 373);
        this.CanvasStatusLabel.setHorizontalAlignment(0);
        this.CanvasStatusLabel.setLabelFor(this.canvas1);
        this.CanvasStatusLabel.setText(resourceMap.getString("CanvasStatusLabel.text", new Object[0]));
        this.CanvasStatusLabel.setHorizontalTextPosition(2);
        this.CanvasStatusLabel.setName("CanvasStatusLabel");
        this.CanvasStatusLabel.setPreferredSize(new Dimension(358100, 11));
        this.mainPanel.add(this.CanvasStatusLabel);
        this.CanvasStatusLabel.setBounds(200, 630, 890, 21);
        this.torsoTwistPanel.setDoubleBuffered(true);
        this.torsoTwistPanel.setName("torsoTwistPanel");
        this.torsoTwistPanel.setVisible(false);
        this.torsoTwistLeftBtn.setText(resourceMap.getString("torsoTwistLeftBtn.text", new Object[0]));
        this.torsoTwistLeftBtn.setName("torsoTwistLeftBtn");
        this.torsoTwistLeftBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BTClientALPHAView.this.torsoTwistLeftBtnActionPerformed(evt);
            }
        });
        this.torsoTwistRightBtn.setText(resourceMap.getString("torsoTwistRightBtn.text", new Object[0]));
        this.torsoTwistRightBtn.setName("torsoTwistRightBtn");
        this.torsoTwistRightBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BTClientALPHAView.this.torsoTwistRightBtnActionPerformed(evt);
            }
        });
        this.jButton1.setFont(resourceMap.getFont("jButton1.font"));
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setName("jButton1");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BTClientALPHAView.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        GroupLayout torsoTwistPanelLayout = new GroupLayout(this.torsoTwistPanel);
        this.torsoTwistPanel.setLayout(torsoTwistPanelLayout);
        torsoTwistPanelLayout.setHorizontalGroup(torsoTwistPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(torsoTwistPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(torsoTwistPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel1, -1, 79, Short.MAX_VALUE).addComponent(this.torsoTwistLeftBtn, -2, 51, -2).addComponent(this.jButton1).addComponent(this.torsoTwistRightBtn)).addGap(31, 31, 31)));
        torsoTwistPanelLayout.setVerticalGroup(torsoTwistPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, torsoTwistPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.torsoTwistLeftBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton1, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.torsoTwistRightBtn).addGap(16, 16, 16)));
        this.mainPanel.add(this.torsoTwistPanel);
        this.torsoTwistPanel.setBounds(40, 500, 120, 140);
        this.jPanel1.setName("jPanel1");
        this.PhaseChange.setText(resourceMap.getString("PhaseChange.text", new Object[0]));
        this.PhaseChange.setName("PhaseChange");
        this.PhaseChange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BTClientALPHAView.this.PhaseChangeActionPerformed(evt);
            }
        });
        this.rollDiceBtn.setIcon(resourceMap.getIcon("DieRollBTN.icon"));
        this.rollDiceBtn.setText(resourceMap.getString("DieRollBTN.text", new Object[0]));
        this.rollDiceBtn.setBorderPainted(false);
        this.rollDiceBtn.setFocusPainted(false);
        this.rollDiceBtn.setName("DieRollBTN");
        this.rollDiceBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BTClientALPHAView.this.rollDiceBtnActionPerformed(evt);
            }
        });
        this.diceRollResult.setText(resourceMap.getString("diceRollResult.text", new Object[0]));
        this.diceRollResult.setName("diceRollResult");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rollDiceBtn, -2, 103, -2).addGroup(jPanel1Layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.PhaseChange))).addGap(27, 27, 27)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.diceRollResult, -2, 120, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.diceRollResult, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rollDiceBtn, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.PhaseChange)));
        this.mainPanel.add(this.jPanel1);
        this.jPanel1.setBounds(37, 390, 128, 100);
        this.canvas1.setBackground(resourceMap.getColor("canvas1.background"));
        this.canvas1.setCursor(new Cursor(0));
        this.canvas1.setName("canvas1");
        this.canvas1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                BTClientALPHAView.this.canvas1MouseClicked(evt);
            }
        });
        this.canvas1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                BTClientALPHAView.this.canvas1KeyPressed(evt);
            }
        });
        this.mainPanel.add(this.canvas1);
        this.canvas1.setBounds(200, 10, 890, 620);
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        ApplicationActionMap actionMap = Application.getInstance(BTClientALPHAApp.class).getContext().getActionMap(BTClientALPHAView.class, this);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        this.PhaseLabel.setFont(resourceMap.getFont("PhaseLabel.font"));
        this.PhaseLabel.setText(resourceMap.getString("PhaseLabel.text", new Object[0]));
        this.PhaseLabel.setName("PhaseLabel");
        this.PhaseStatus.setText(this.phase.getPhaseName());
        this.PhaseStatus.setName("PhaseStatus");
        this.torsoTwistLabel.setHorizontalAlignment(0);
        this.torsoTwistLabel.setText(resourceMap.getString("torsoTwistLabel.text", new Object[0]));
        this.torsoTwistLabel.setName("torsoTwistLabel");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 1106, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusMessageLabel).addGroup(statusPanelLayout.createSequentialGroup().addComponent(this.PhaseLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.PhaseStatus).addGap(38, 38, 38).addComponent(this.torsoTwistLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 688, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel))).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 11, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(statusPanelLayout.createSequentialGroup().addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.PhaseLabel).addComponent(this.PhaseStatus).addComponent(this.torsoTwistLabel)))));
        this.jFrame1.setTitle(resourceMap.getString("jFrame1.title", new Object[0]));
        this.jFrame1.setName("jFrame1");
        this.jFrame1.setResizable(false);
        GroupLayout jFrame1Layout = new GroupLayout(this.jFrame1.getContentPane());
        this.jFrame1.getContentPane().setLayout(jFrame1Layout);
        jFrame1Layout.setHorizontalGroup(jFrame1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        jFrame1Layout.setVerticalGroup(jFrame1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void rollDiceBtnActionPerformed(ActionEvent evt) {
        this.diceRollResult.setText("You rolled a: " + Integer.toString(this.dice.rollDie(2)));
    }

    private void PhaseChangeActionPerformed(ActionEvent evt) {
        this.phase.nextPhase();
        if (this.phase.getPhase() == 0) {
            // empty if block
        }
        this.CanvasStatusLabel.setText("Roll for initiative...");
        if (this.phase.getPhase() == 1) {
            this.moves = this.pm1.getMech(0).getRunningSpeed();
            this.moveWalkValueLabel.setText(Integer.toString(this.pm1.getMech(0).getWalkingSpeed()));
            this.moveRunValueLabel.setText(Integer.toString(this.pm1.getMech(0).getRunningSpeed()));
            this.moveModValueLabel.setText(Integer.toString(this.pm1.getMech(0).getMovementMod()));
            this.moveAvailValueLabel.setText(Integer.toString(this.moves));
            this.movementPanel.setVisible(true);
            this.CanvasStatusLabel.setText("Walk, Run, or Stand Still...");
        }
        if (this.phase.getPhase() == 2) {
            this.moves = 0;
            this.movementPanel.setVisible(false);
            this.torsoTwistPanel.setVisible(true);
            this.CanvasStatusLabel.setText("Twist it baby...");
        }
        if (this.phase.getPhase() == 3) {
            this.torsoTwistPanel.setVisible(false);
            this.wep1Btn.setEnabled(true);
            this.wep2Btn.setEnabled(true);
            this.wep3Btn.setEnabled(true);
            this.wep4Btn.setEnabled(true);
            this.wep5Btn.setEnabled(true);
            this.CanvasStatusLabel.setText("Fire Zeh Weapons!");
        }
        if (this.phase.getPhase() == 4) {
            this.wep1Btn.setEnabled(false);
            this.wep2Btn.setEnabled(false);
            this.wep3Btn.setEnabled(false);
            this.wep4Btn.setEnabled(false);
            this.wep5Btn.setEnabled(false);
            this.CanvasStatusLabel.setText("Physical Attacks not implemented");
        }
        if (this.phase.getPhase() == 6) {
            this.pm1.playerMech[0].heatPhase();
            this.heatLevelValue.setText(Integer.toString(this.pm1.getMech(0).getHeat()) + " (" + Integer.toString(this.pm1.getMech(0).getBuiltHeat()) + ")");
            this.CanvasStatusLabel.setText("Heat level calculated...");
        }
        this.uiUpdate();
    }

    private void canvas1MouseClicked(MouseEvent evt) {
        this.CanvasStatusLabel.setText("Stop clicking me!");
    }

    private void canvas1KeyPressed(KeyEvent evt) {
        if (this.phase.getPhase() == 1 && this.moves > 0) {
            if (evt.getKeyCode() == 38) {
                this.CanvasStatusLabel.setText("Forward");
                this.tempCanvas.mechForward();
            }
            if (evt.getKeyCode() == 40) {
                this.CanvasStatusLabel.setText("Back");
                this.tempCanvas.mechBackward();
            }
            if (evt.getKeyCode() == 37) {
                this.CanvasStatusLabel.setText("Turn Left");
                this.tempCanvas.mechTurnLeft();
            }
            if (evt.getKeyCode() == 39) {
                this.CanvasStatusLabel.setText("Turn Right");
                this.tempCanvas.mechTurnRight();
            }
            --this.moves;
            this.moveAvailValueLabel.setText(Integer.toString(this.moves));
            this.canvas1.repaint();
        } else {
            this.CanvasStatusLabel.setText("No more movement points!");
        }
    }

    private void wep2BtnActionPerformed(ActionEvent evt) {
        MechBody temp = this.pm1.getMech(0);
        temp.addHeat(temp.getWeapons()[1].getHeat());
        this.wep2Btn.setEnabled(false);
        this.uiUpdate();
    }

    private void wep1BtnActionPerformed(ActionEvent evt) {
        MechBody temp = this.pm1.getMech(0);
        temp.getWeapons()[0].useAmmo();
        temp.addHeat(temp.getWeapons()[0].getHeat());
        this.wep1Btn.setEnabled(false);
        this.uiUpdate();
    }

    private void wep3BtnActionPerformed(ActionEvent evt) {
        MechBody temp = this.pm1.getMech(0);
        temp.addHeat(temp.getWeapons()[2].getHeat());
        this.wep3Btn.setEnabled(false);
        this.uiUpdate();
    }

    private void wep4BtnActionPerformed(ActionEvent evt) {
        MechBody temp = this.pm1.getMech(0);
        temp.addHeat(temp.getWeapons()[3].getHeat());
        this.wep4Btn.setEnabled(false);
        this.uiUpdate();
    }

    private void wep5BtnActionPerformed(ActionEvent evt) {
        MechBody temp = this.pm1.getMech(0);
        temp.addHeat(temp.getWeapons()[4].getHeat());
        this.wep5Btn.setEnabled(false);
        this.uiUpdate();
    }

    private void torsoTwistLeftBtnActionPerformed(ActionEvent evt) {
        this.pm1.getMech(0).torsoTwistLeft();
        this.torsoTwistLabel.setText("Torso Twist: Left");
    }

    private void torsoTwistRightBtnActionPerformed(ActionEvent evt) {
        this.pm1.getMech(0).torsoTwistRight();
        this.torsoTwistLabel.setText("Torso Twist: Right");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.pm1.getMech(0).torsoTwistCenter();
        this.torsoTwistLabel.setText("Torso Twist: Center");
    }

    private void uiUpdate() {
        this.PhaseStatus.setText(this.phase.getPhaseName());
        this.PlayerNameLabel.setText(this.pm1.getPlayerName());
        this.mechNameLabel.setText(this.pm1.getMechName(0));
        this.tonnageValueLabel.setText(Double.toString(this.pm1.getMech(0).currentBuildTonnage()));
        int[] temp = this.pm1.getArmorValues(0);
        this.headArmorLabel.setText(Integer.toString(temp[0]));
        this.leftLegArmorLabel.setText(Integer.toString(temp[1]));
        this.leftArmArmorLabel.setText(Integer.toString(temp[2]));
        this.leftTorsoArmorLabel.setText(Integer.toString(temp[3]));
        this.leftTorsoRearArmorLabel.setText("(" + Integer.toString(temp[4]) + ")");
        this.centerTorsoArmorLabel.setText(Integer.toString(temp[5]));
        this.centerTorsoRearArmorLabel.setText("(" + Integer.toString(temp[6]) + ")");
        this.rightTorsoArmorLabel.setText(Integer.toString(temp[7]));
        this.rightTorsoRearArmorLabel.setText("(" + Integer.toString(temp[8]) + ")");
        this.rightArmArmorLabel.setText(Integer.toString(temp[9]));
        this.rightLegArmorLabel.setText(Integer.toString(temp[10]));
        this.heatLevelValue.setText(Integer.toString(this.pm1.getMech(0).getHeat()) + " (" + Integer.toString(this.pm1.getMech(0).getBuiltHeat()) + ")");
        Weapon[] weps = this.pm1.getWeapons(0);
        this.weapon1Label.setText(weps[0].getNick());
        this.weapon1AmmoValue.setText(Integer.toString(weps[0].getAmmo()));
        this.weapon2Label.setText(weps[1].getNick());
        this.weapon2AmmoValue.setText(Integer.toString(weps[1].getAmmo()));
        this.weapon3Label.setText(weps[2].getNick());
        this.weapon3AmmoValue.setText(Integer.toString(weps[2].getAmmo()));
        this.weapon4Label.setText(weps[3].getNick());
        this.weapon4AmmoValue.setText(Integer.toString(weps[3].getAmmo()));
        this.weapon5Label.setText(weps[4].getNick());
        this.weapon5AmmoValue.setText(Integer.toString(weps[4].getAmmo()));
    }
}

