/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.x11;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLDrawableImpl;
import com.sun.opengl.impl.x11.GLX;
import com.sun.opengl.impl.x11.X11GLDrawableFactory;
import com.sun.opengl.impl.x11.XVisualInfo;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLException;

public abstract class X11GLDrawable
extends GLDrawableImpl {
    protected static final boolean DEBUG = Debug.debug("X11GLDrawable");
    protected long display;
    protected long drawable;
    protected long visualID;
    protected GLCapabilities capabilities;
    protected GLCapabilitiesChooser chooser;

    public X11GLDrawable(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser) {
        this.capabilities = gLCapabilities == null ? null : (GLCapabilities)gLCapabilities.clone();
        this.chooser = gLCapabilitiesChooser;
    }

    public void setRealized(boolean bl) {
        throw new GLException("Should not call this (should only be called for onscreen GLDrawables)");
    }

    public void destroy() {
        throw new GLException("Should not call this (should only be called for offscreen GLDrawables)");
    }

    public void swapBuffers() throws GLException {
    }

    public long getDisplay() {
        return this.display;
    }

    public long getDrawable() {
        return this.drawable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XVisualInfo chooseVisual(boolean bl) {
        int n;
        if (this.display == 0L) {
            throw new GLException("null display");
        }
        if (bl) {
            int[] nArray = new int[1];
            XVisualInfo xVisualInfo = XVisualInfo.create();
            xVisualInfo.visualid((int)this.visualID);
            this.lockToolkit();
            XVisualInfo[] xVisualInfoArray = GLX.XGetVisualInfo(this.display, 1L, xVisualInfo, nArray, 0);
            this.unlockToolkit();
            if (xVisualInfoArray == null || xVisualInfoArray.length == 0) {
                throw new GLException("Error while getting XVisualInfo for visual ID " + this.visualID);
            }
            if (DEBUG) {
                System.err.println("!!! Fetched XVisualInfo for visual ID 0x" + Long.toHexString(this.visualID));
                System.err.println("!!! Resulting XVisualInfo: visualid = 0x" + Long.toHexString(xVisualInfoArray[0].visualid()));
            }
            return xVisualInfoArray[0];
        }
        int n2 = 0;
        XVisualInfo xVisualInfo = null;
        int[] nArray = new int[1];
        XVisualInfo xVisualInfo2 = XVisualInfo.create();
        xVisualInfo2.screen(n2);
        XVisualInfo[] xVisualInfoArray = null;
        GLCapabilities[] gLCapabilitiesArray = null;
        this.lockToolkit();
        try {
            xVisualInfoArray = GLX.XGetVisualInfo(this.display, 2L, xVisualInfo2, nArray, 0);
            if (xVisualInfoArray == null) {
                throw new GLException("Error while enumerating available XVisualInfos");
            }
            gLCapabilitiesArray = new GLCapabilities[xVisualInfoArray.length];
            for (n = 0; n < xVisualInfoArray.length; ++n) {
                gLCapabilitiesArray[n] = X11GLDrawableFactory.xvi2GLCapabilities(this.display, xVisualInfoArray[n]);
            }
        }
        finally {
            this.unlockToolkit();
        }
        n = this.chooser.chooseCapabilities(this.capabilities, gLCapabilitiesArray, -1);
        if (n < 0 || n >= gLCapabilitiesArray.length) {
            throw new GLException("GLCapabilitiesChooser specified invalid index (expected 0.." + (gLCapabilitiesArray.length - 1) + ")");
        }
        if (DEBUG) {
            System.err.println("Chosen visual (" + n + "):");
            System.err.println(gLCapabilitiesArray[n]);
        }
        if ((xVisualInfo = xVisualInfoArray[n]) == null) {
            throw new GLException("GLCapabilitiesChooser chose an invalid visual");
        }
        return xVisualInfo;
    }

    protected void lockToolkit() {
        X11GLDrawableFactory.getX11Factory().lockToolkit();
    }

    protected void unlockToolkit() {
        X11GLDrawableFactory.getX11Factory().unlockToolkit();
    }
}

