package objects.Factories;

import javax.media.j3d.Appearance;
import javax.media.j3d.Material;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;


import main.TerrainManager;

import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.picking.PickTool;

public class StaticFactory extends Factory 
{
	// obstacle dimensions (for both block-like things and cylinders)
	private final static float RADIUS = 0.5f;
	// for a block, RADIUS == length of a side/2
	private final static float HEIGHT = 1.0f;
	private final static float FLOOR_HEIGHT = 0.15f;
	
	// Colors for obstacle material
	private final static Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
	private final static Color3f white = new Color3f(0.50f, 0.50f, 0.50f);  //TODO need that many color
	private final static Color3f blue = new Color3f(0.0f, 0.0f, 1.0f); 
	private final static Color3f medgreen = new Color3f(0.0f, 0.5f, 0.1f);
	
	// textures used for the obstacles
	private final static String BLOCK_TEX = "images/plate.jpg";
	private final static String CYL_TEX = "images/cobbles.jpg";
	private final static String FLOOR_IMG = "images/stone.jpg";
	
	private Appearance blockApp, cylApp, basicFloorApp;   // obstacle appearances

	public StaticFactory()
	{
	    // the Appearance nodes used by all the blocks and cylinders
	    blockApp = makeAppearance(blue, BLOCK_TEX);       // blue texture for blocks
	    cylApp = makeAppearance(medgreen, CYL_TEX);       // green texture for cylinders
	    basicFloorApp = makeAppearance(white, FLOOR_IMG); // black texture for basic floor
	}
	
	public TransformGroup getObject(char type, double z, double x, int y, PickTool pickTool) 
	{
		Primitive obstical; 
	    switch(type)
	    {
	    case TerrainManager.STATIC_BLOCK: // blue textured block
	    	obstical = new Box(HEIGHT/2, HEIGHT, HEIGHT/2, 
					Primitive.GENERATE_TEXTURE_COORDS |
					Primitive.GENERATE_NORMALS, blockApp );
	    	break;
	    case TerrainManager.CYLINDER_BLOCK: // green textured cylinder
	    	obstical = new Cylinder(RADIUS, HEIGHT*2, 
					Primitive.GENERATE_TEXTURE_COORDS |
					Primitive.GENERATE_NORMALS, cylApp );
	    	break;
	    case TerrainManager.STANDARD_FLOOR_TYLE: // a standard textured floor block
	    	obstical = new Box(RADIUS,0,RADIUS,
	    			Primitive.GENERATE_TEXTURE_COORDS|
	    			Primitive.GENERATE_NORMALS, basicFloorApp);
	    	break;
	    default:
	    	obstical = new Cylinder(RADIUS, HEIGHT, 
					Primitive.GENERATE_TEXTURE_COORDS |
					Primitive.GENERATE_NORMALS, cylApp );
	    	break;
	    }
	     
	    if ( obstical instanceof Box ) 
	    {
			pickTool.setCapabilities(obstical.getShape(Box.FRONT),
					PickTool.INTERSECT_FULL);
			pickTool.setCapabilities(obstical.getShape(Box.BACK),
					PickTool.INTERSECT_FULL);
			pickTool.setCapabilities(obstical.getShape(Box.LEFT),
					PickTool.INTERSECT_FULL);
			pickTool.setCapabilities(obstical.getShape(Box.RIGHT),
					PickTool.INTERSECT_FULL);
		}
	    else
	    {
	    	pickTool.setCapabilities(obstical.getShape(Cylinder.BODY),
					PickTool.INTERSECT_FULL);
	    }
		double height = 0;
	    switch(y)
	    {
	    case 6://TODO magic numbers
	    	height += HEIGHT;
	    case 5:
	    	height += 6*FLOOR_HEIGHT;
	    case 4:
	    	height += HEIGHT;
	    case 3:
	    	height += 6*FLOOR_HEIGHT;
	    case 2:
	    	height += HEIGHT;
	    case 1:
	    	height += 6*FLOOR_HEIGHT;
	    default:
	    	height += 0;
	    	break;
	    }
	    
	    // position the obstacle so its base is resting on the floor at (x,z)
	    TransformGroup posnTG = new TransformGroup();
	    Transform3D trans = new Transform3D();
	    trans.setTranslation( new Vector3d(x, height, z) );  // move up
	    posnTG.setTransform(trans);
	    posnTG.addChild(obstical);
	    return posnTG;
	}
	
	private Appearance makeAppearance(Color3f color, String texture_file_name)
	{
		Appearance app = new Appearance();

	    // mix the texture and the material colour
	    TextureAttributes textureAttributes = new TextureAttributes();
	    textureAttributes.setTextureMode(TextureAttributes.MODULATE);
	    app.setTextureAttributes(textureAttributes);

	    // load and set the texture
	    System.out.println("Loading obstacle texture from " + texture_file_name);
	    TextureLoader loader = new TextureLoader(texture_file_name, null);
	    Texture2D texture = (Texture2D) loader.getTexture();
	    app.setTexture(texture);      // set the texture

	    // add a coloured material
	    Material mat = new Material(color, black, color, white, 20.f);
	    mat.setLightingEnable(true);
	    app.setMaterial(mat);
	    return app;
	}  // end of makeAppearance()
}
