package objects;

import java.util.ArrayList;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.picking.PickTool;

import main.TerrainManager;

import objects.AI.NodeTree;
import objects.AI.Node;
import utils.Logger;

public class DynamicObjectManager 
{
	private NodeTree tree;
	private Logger log;
	private PickTool pickTool;
	private ArrayList< DynamicObject > objList;
	private ArrayList< ArrayList< Integer > > patrolPaths;
	
	private Node node;
	private Point3d collidie;
	private int counter = 1;
	
	public DynamicObjectManager( Logger log )
	{
		this.log = log;
		tree = new NodeTree( log );
		objList = new ArrayList< DynamicObject >();
	}

	public void addNodeToTree( String[] split ) 
	{
		collidie = new Point3d( Integer.parseInt( split[1] ) + TerrainManager.COORD_OFFSET, 
				TerrainManager.PLAYABLE_AREA + TerrainManager.COORD_OFFSET, 
				Integer.parseInt( split[0] ) + TerrainManager.COORD_OFFSET );
		node = new Node( counter, collidie );
		tree.add( node );
		counter++;
	}

	public void addLinksToNode( String[] split ) 
	{
		node = tree.getNode( Integer.parseInt( split[0] ) );
		node.setChildren(split);
	}
	
	public double range( Vector3d nextPosition, Vector3d vector3d )
	{
		// sqrt( (point.z-z)^2 + (point.x-x)^2 ) or sqrt( x^2 + y^2 ), basically Pythagorean Theorem
		return new Vector3d( ( vector3d.x - nextPosition.x ), ( vector3d.y - nextPosition.y ), 
				( vector3d.z - nextPosition.z ) ).length();	
	}

	public void printTree() {
		tree.print();
	}
	
	private String print;
	
	public String  printObjectList()
	{
		print = "";
		int i = 0;
		for( DynamicObject object: objList )
		{
			print += "objectList(" + i++ + "): " + object.getClass() + "(" + object.getPosition()+ ")" + "\n";
		}
		return print;
	}

	public synchronized void removeObject( DynamicObject object ) 
	{
		objList.remove( object );
	}

	public synchronized void addObject(Primitive object) 
	{
		for( DynamicObject object2:objList )
		{
			if( object2.getName().equalsIgnoreCase( ( (DynamicObject) object.getUserData() ).getName() ) )
			{
				// if it's already on the list, we do nothing with it.
				return;
			}
		}
		
		objList.add( ( DynamicObject ) object.getUserData() );
		
		if (object instanceof Box) 
		{
			// there are no instances of the Box primitive shape that are dynamic and pickable
		}
		else
		{
			// this is for all the cones
			pickTool.setCapabilities(object.getShape(Cone.BODY), PickTool.INTERSECT_FULL);
			pickTool.setCapabilities(object.getShape(Cone.CAP), PickTool.INTERSECT_FULL);
		}
		log.println(this.printObjectList());
	}
	
	private ArrayList<DynamicObject> collided;
	
	public synchronized ArrayList<DynamicObject> collisionDetection( DynamicObject collider )
	{
		collided = new ArrayList<DynamicObject>();
		Vector3d nextPosition = collider.getPosition();
		double range = 0;
		for( DynamicObject collidie: objList )
		{
			range = range( nextPosition, collidie.getPosition() );
			// simulates two bounding spheres colliding
			if( range <= ( collidie.getRange() +collider.getRange() ) )
			{
				collided.add(collidie);
			}
			else
			{
				// do nothing
			}
		}
		return collided;
	}

	public synchronized ArrayList<DynamicObject> targetAcquisition() 
	{
		return objList;
	}

	/**
	 * This is to create a list of dynamic objects that are in range of a given point, represented by the vector
	 * @param vector3d 
	 * @param range
	 * @return
	 */
	public ArrayList< DynamicObject > getObjectList() 
	{
		return objList;
	}
}
