package objects;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public interface DynamicObject 
{	
	/**
	 * This is for getting the position of the object in (z,x,y) space.
	 * @return the position
	 */
	public Vector3d getPosition();

	/**
	 * This is to get the range of something TODO need to rewrite this.
	 * @return the range
	 */
	public double getRange();

	/**
	 * This performs the effect that happens when a collision is detected to the data,
	 * which represents the object that was ran into with.
	 * @param data
	 */
	public void collidingEffectOn(DynamicObject data);

	/**
	 * This method represents damage taken when a collision is detect, since this is the only
	 * type of collision that is currently not simple and grid-based. <br/> The damage is
	 * recorded in pairs, the first is the amount of damage, the second is the type.<br/>
	 * <ul>
	 * 	<li>0 = physical damage</li>
	 * 	<li>1 = fire damage</li>
	 * 	<li>more to be added later</li>
	 * </ul>
	 * @param damage
	 * @param type 
	 */
	public int doDamage(int[] damage);

	public String getName();
}
