package objects.AI;

import java.util.Hashtable;

import utils.Logger;

public class NodeTree 
{
	public static final Integer NULL_COST_VALUE = 50;
	
	private Hashtable< Integer, Node > tree;
	private Logger log;
	
	public NodeTree(Logger log) 
	{
		this.log = log;
		tree = new Hashtable< Integer, Node >();
	}

	public void add( Node node ) 
	{
		tree.put( node.getNodeNumber(), node );
	}

	public Node getNode( int nodeNumber ) 
	{
		try {
			return tree.get(nodeNumber);
		} catch (Exception e) {
			log.println("The numbee that threw an error was "+nodeNumber+": "+e.getMessage());
			e.printStackTrace();
		}
		return null;
	}
	
	public void print()
	{
		for( Integer node: tree.keySet() )
		{
			log.println( tree.get( node ).print(), Logger.NOTE+Logger.TREE );
		}
	}
}
