package objects.AI;

import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

import main.AmmoManager;
import main.TerrainManager;

import objects.DynamicObject;
import objects.DynamicObjectManager;
import objects.Spells.Enchant;
import utils.Logger;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Primitive;

public abstract class IntelegentObject implements DynamicObject
{
	private final float RADIUS = 0.25f;
	private final float LENGTH = 0.50f;

    private static float DEFAULT_MAX_HEALTH = 100;
    private static final float WOUNDED_HEALTH_PERCENT = 0.5f;
    private static final float CRITICAL_HEALTH_PERCENT = 0.25f;
    protected static final float DEATH = 0;
	
	private Enchant spell;            // This is the enchantment, that may or may not exist, and can have an appearance
	                                  // grabbed from.
	private Appearance fullHealth;    // green skin
	private Appearance halfHealth;    // yellow skin
	private Appearance quarterHealth; // red skin
	private Logger log;
	protected DynamicObjectManager objectManager;
	protected AmmoManager ammoManager;
	private TerrainManager terrain;
	private Cone cone;
	private Vector3d startPosition;
	private Vector3d currentPosition;
	private TransformGroup model;
	
	// how much damage any given object can do. int[1] is the types: 0 = physical, 1 = fire
	private final int[] DAMAGE = new int[] { 20, 0 }; 
	protected int life = 100;  // how much damage any given object can take before destruction.
	protected int damageDelt = 0; // ... to other objects
	protected double range = 0;
	
	public IntelegentObject( Logger log, DynamicObjectManager objectManager, TerrainManager terrain, Vector3d start)
	{
		super();
		startPosition = start;
		currentPosition = (Vector3d) startPosition.clone();
		this.log = log;
		this.objectManager = objectManager;
		this.terrain = terrain;
	}

	@Override
	public Vector3d getPosition()
	{
		return currentPosition;
	}

	@Override
	public double getRange() 
	{
		return range;
	}

	public Node getAvatar() 
	{
		BranchGroup branchGroup = new BranchGroup();
		Transform3D transform3d = new Transform3D();
		transform3d.rotX( Math.PI/2 );	// rotate so top of cone is facing front
		transform3d.transform(currentPosition);
		model = new TransformGroup( transform3d );
		
		makeAppearances();
		cone = new Cone( RADIUS, LENGTH, 
				//Sphere.GENERATE_TEXTURE_COORDS, 
				fullHealth );
		cone.setCapability( Primitive.ENABLE_APPEARANCE_MODIFY );
		cone.setUserData( this );
		objectManager.addObject( cone );
		
		model.addChild( cone );  // avatar is a cone
		model.setCapability( Node.ALLOW_LOCAL_TO_VWORLD_READ );  // for testing position later
		
		ammoManager = new AmmoManager( model, branchGroup, terrain, "fire", log, objectManager );
		
		branchGroup.addChild( model );
		
		objectManager.addObject(cone);
		
		return branchGroup;
	}
	
	private void makeAppearances()
	{
		Color3f mediumGreen = new Color3f( 0.4f, 1f, 0.3f );
		Color3f mediumYellow = new Color3f( 0.7f, 0.7f, 0.3f );
		Color3f mediumRed = new Color3f(1f, 0.4f, 0.3f);
		/*
		String greenTexture = "roof1.png";
		String yellowTexture = "texture_G.png";
		String redTexture = "wall1.png";//*/
		
		fullHealth = makeAppearance(mediumGreen);//,greenTexture);
		halfHealth = makeAppearance(mediumYellow);//,yellowTexture);
		quarterHealth = makeAppearance(mediumRed);//,redTexture);
	}
	
	private Appearance makeAppearance( Color3f color)//, String textureName )
	{
		Appearance appearance = new Appearance();
		/*
		TextureLoader loader = new TextureLoader("./images/"+textureName, null);
	    Texture2D texture = (Texture2D) loader.getTexture();
	    
		TextureAttributes textureAttributes = new TextureAttributes();
	    textureAttributes.setTextureMode( TextureAttributes.MODULATE );
	    appearance.setTextureAttributes( textureAttributes );
	    appearance.setTexture( texture );//*/
	    
		Color3f black = new Color3f( 0.0f, 0.0f, 0.0f );
		Color3f specular = new Color3f( 0.9f, 0.9f, 0.9f );

		Material material = new Material( color, black, color, specular, 80.0f );
		material.setLightingEnable(true);
	    appearance.setMaterial( material );
		
		return appearance;
	} // end of makeAppearance()

	@Override
	public void collidingEffectOn( DynamicObject data ) 
	{
		if( spell != null )
		{
			int[] extra = spell.getDamageToInflict();
			damageDelt += data.doDamage( new int[] {DAMAGE[0], DAMAGE[1], extra[0], extra[1] } );
		}
		else
		{
			damageDelt += data.doDamage( DAMAGE );
		}
	}

	@Override
	public int doDamage( int[] damage ) 
	{
		int totalDamage = 0;
		int damageTaken;
		for( int wound:damage )
		{
			totalDamage += wound;
		}
		
		if( spell != null )
		{
			life -= (damageTaken = (totalDamage - spell.getDamageToPrevent( damage ) ) );
		}
		else
		{
			life -= (damageTaken = totalDamage );
		}
		
		if( life > DEFAULT_MAX_HEALTH*WOUNDED_HEALTH_PERCENT )
		{
			// This is here for when the healing items are put in.
		}
		else if( life > DEFAULT_MAX_HEALTH*CRITICAL_HEALTH_PERCENT )
		{
			cone.setAppearance( halfHealth );
		}
		else if( life > DEATH )
		{
			cone.setAppearance( quarterHealth );
		}
		else
		{
			reset();
		}
		
		return damageTaken;
	}

	protected void reset() 
	{
		Transform3D transform3d = new Transform3D();
		transform3d.set( startPosition );
		model.setTransform( transform3d );
		life = (int) DEFAULT_MAX_HEALTH;
		cone.setAppearance(fullHealth);
		getInstincts();
	}

	private void getInstincts() {}
}
