package objects.AI;

import java.util.ArrayList;
import java.util.Iterator;

import javax.media.j3d.Shape3D;
import javax.vecmath.Vector3d;

import com.sun.j3d.utils.picking.PickTool;

import main.AmmoManager;
import main.Controller;
import main.TerrainManager;
import objects.DynamicObject;
import objects.DynamicObjectManager;
import objects.Effects.AIBehavior;
import utils.Logger;

public class AI extends IntelegentObject
{
	private static final float DEFAULT_SPEED = 1.0f;
    private static final long DEFAULT_PATH_RECALC_TIME = 4000;
    private static final int DEFAULT_TIME_DELAY = 100;
    private static final int STUN_DELAY = 5;
    private static final int MAXIMUM_CHASE_TIME = 30;
	
    public static final int NORMAL_STATE_IDLE = 0;
    public static final int NORMAL_STATE_PATROL = 1;
    public static final int NORMAL_STATE_CHASE = 2;
    public static final int BATTLE_STATE_ATTACK = 3;
    public static final int BATTLE_STATE_RUN_AWAY = 5;
    public static final int WOUNDED_STATE_HURT = 6;
    public static final int DECESION_READY = 9;
    
    public int aiNumber;
    
    private int timeInPlay = 0;
    private int timeSinceTargetLastSeen = 999;
    
    private PathFinder pathFinder;
    private Iterator currentPath;
    private Vector3d nextPathLocation;
	private Instinct brain;
	private EvolutionGenePool genePool;
	private ArrayList< DynamicObject > targetList;
	private PickTool lineOfSight;
	private int aiState;
	private int timeStunned;
    private long timeSincePathRecalc;
    private long pathRecalcTime;

	public AI( Logger log, DynamicObjectManager objectManager,
			TerrainManager terrain, Vector3d start ) 
	{
		super( log, objectManager, terrain, start );
	}

	public AI( Vector3d position, Logger log,
			DynamicObjectManager objectManager, AmmoManager ammoManager,
			TerrainManager terrain, PickTool pickTool, int aiNumber, EvolutionGenePool genePool ) 
	{
		this( log, objectManager, terrain, position );
		this.genePool = genePool;
		this.brain = genePool.getNewBrain();
		lineOfSight = pickTool;
		this.aiNumber = aiNumber;
		
		AIBehavior aiBehavior = new AIBehavior( DEFAULT_TIME_DELAY, this  );
		aiBehavior.setSchedulingBounds( Controller.UNIVERSE_BOUNDS );
		terrain.getTerrain().addChild( aiBehavior );
	}
	
	public void update() 
	{	
		if ( timeInPlay > Instinct.MAX_TIME_TO_LIVE ) 
		{
			reset();
            return;
		}
		else
		{
			timeInPlay++;
		}
		
		// reset if dead for 0.5 seconds
	    if ( life <= DEATH ) 
	    {
	        if (timeStunned >= 5) 
	        {
	            reset();
	            return;
	        }
		}
	    // or if wounded...
	    else if (aiState == WOUNDED_STATE_HURT) 
	    {
	    	// check to see if they are un-stunned from being wounded
	        if (timeStunned >= STUN_DELAY) 
	        {
	        	timeStunned = 0;
	        	aiState = DECESION_READY;
	        }
	        else 
	        {
	        	// it is still stunned, so do nothing.
	        	timeStunned++;
	            return;
	        }
	    }
	
	    // if unstunned, make a decision on what to do
	    if (aiState == DECESION_READY) 
	    {
	    	// if can see a target, attack
	        if (canSeeATarget()) 
	        {
	        	timeSinceTargetLastSeen = 0;
	            setAiState(chooseBattleState());
	        }
	        // else, if have no possible targets, but had one recently, chase after it
	        else if ( timeSinceTargetLastSeen < MAXIMUM_CHASE_TIME && !canSeeATarget() )
	        {
	        	timeSinceTargetLastSeen++;
	            setAiState(NORMAL_STATE_CHASE);
	        }
	        // if no targets recently, then patrol
	        else 
	        {
	            setAiState(NORMAL_STATE_PATROL);
	        }
	    }
	}
	
	private boolean canSeeATarget() 
	{
		if ( targetList.size() == 0 ) 
		{
			targetList = objectManager.targetAcquisition(); 
		}
		else
		{
			// do nothing
		}
		
		if ( targetList != null && targetList.size() > 0 ) 
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	protected void setAiState( int aiState ) 
	{
		// update path
        switch (aiState) 
        {
        case NORMAL_STATE_IDLE:
        case NORMAL_STATE_PATROL:
//       	setPathFinder(brain.idlePathFinder);
            break;
        case NORMAL_STATE_CHASE:
//            setPathFinder(brain.chasePathFinder);
            break;
        case BATTLE_STATE_ATTACK:
//            setPathFinder(brain.attackPathFinder);
            break;
        case BATTLE_STATE_RUN_AWAY:
//            setPathFinder(brain.runAwayPathFinder);
            break;
        case WOUNDED_STATE_HURT:
            setPathFinder(null);
            break;
        default:
            setPathFinder(null);
            break;
        }
    }
	
	/**
	 * Sets the PathFinder class to use to follow the path.
	 * */
	public void setPathFinder(PathFinder pathFinder) 
	{
		if ( this.pathFinder != pathFinder ) 
		{
			this.pathFinder = pathFinder;
            currentPath = null;
			timeSincePathRecalc = 0;
	    }
	}
	
    public int chooseBattleState() 
    {
        float p = (float)Math.random();
        if (p <= brain.chanceToRangedAttack) 
        {
            return BATTLE_STATE_ATTACK;
        }
        else 
        {
            return BATTLE_STATE_RUN_AWAY;
        }
    }
	
    /**
    Checks if this object can see the specified object,
    (assuming this object has eyes in the back of its head).
     */
	public boolean canSee() 
	{
		// TODO need to implement this
		return true;
	}

	@Override
	public String getName() 
	{
		return "AI number " + aiNumber;
	}
	
	public void reset()
	{
		super.reset();// TODO need to do this, too
        damageDelt += ammoManager.getAllDamage();
        genePool.notifyDead(brain, damageDelt, timeInPlay );
        brain = genePool.getNewBrain();
        damageDelt = 0;
        setAiState(DECESION_READY);
        setPathFinder(null);
        timeSinceTargetLastSeen = 999;
	}
}
