package main;

import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.util.Enumeration;

import javax.media.j3d.Transform3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

import utils.Logger;

import com.sun.j3d.utils.behaviors.vp.ViewPlatformAWTBehavior;

public class KeyAndMouseBehavior extends ViewPlatformAWTBehavior 
{
	/** The move amount in a NEWS manner */
	private final static double MOVE_AMT = 0.10;
	/** The rotation amount with one key press or mouse move*/
	private final static double ROT_AMT = Math.PI / 8.0;  // 22.5 degrees
	private static double rotated = Math.PI/2; // This indicates how much the player is rotated off of 0 radians
	
	/* Hard-wired movement vectors.
	   These moves are for the viewpoint where forward means moving
	   into the scene, making the z-axis value smaller. Left, right,
	   back, up, and down are all relative to that orientation.
	*/
	private static final Vector3d VFWD = new Vector3d(0, 0, -MOVE_AMT);
	private static final Vector3d VBACK = new Vector3d(0, 0, MOVE_AMT);
	private static final Vector3d VLEFT = new Vector3d(-MOVE_AMT, 0, 0);
	private static final Vector3d VRIGHT = new Vector3d(MOVE_AMT, 0, 0);
	private static final Vector3d VDOWN = new Vector3d(0, -MOVE_AMT, 0);
	private static final Vector3d VUP = new Vector3d(0, MOVE_AMT, 0);
	
	// key names
	private int forwardKey = KeyEvent.VK_UP;
	private int backKey = KeyEvent.VK_DOWN;
	private int leftKey = KeyEvent.VK_LEFT;
	private int rightKey = KeyEvent.VK_RIGHT;
	//private int lookUp = KeyEvent.VK_PAGE_UP;
	//private int lookDown = KeyEvent.VK_PAGE_DOWN;
	private int fireKey = KeyEvent.VK_SPACE;
	private int quitKey = KeyEvent.VK_ESCAPE;
	
	private WakeupCondition keyPress;
	private TerrainManager terrain;	// for checking moves
	private main.AmmoManager ammoManager; // for managing the shots fired
	private Logger log;

	// for repeated calcs
	private Transform3D transform3d = new Transform3D(); 
	// value changed by one method, and then used by another, to keep down recalculation
	private Transform3D toMove = new Transform3D();
	private Transform3D toRot = new Transform3D();
	private Vector3d transformedVector = new Vector3d();
	
	public KeyAndMouseBehavior(TerrainManager terrain, AmmoManager ammoManager, Logger log) {
		keyPress = new WakeupOnAWTEvent( KeyEvent.KEY_PRESSED );
		this.terrain = terrain;
		this.ammoManager = ammoManager;
		this.log = log;
	}

	@Override
	public void initialize() 
	{
		wakeupOn( keyPress );
	}

	public void processStimulus(Enumeration criteria) 
	{
		WakeupCriterion wakeup;
		AWTEvent[] event;

		while( criteria.hasMoreElements() ) 
		{
			wakeup = (WakeupCriterion) criteria.nextElement();
			if( wakeup instanceof WakeupOnAWTEvent ) 
			{
				event = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
				for( int i = 0; i < event.length; i++ ) 
				{
					if( event[i].getID() == KeyEvent.KEY_PRESSED )
					{
						processKeyEvent((KeyEvent)event[i]);
					}
				}
			}
		}
		wakeupOn( keyPress );
	}

	private void processKeyEvent(KeyEvent eventKey)
	{
		int keyCode = eventKey.getKeyCode();
		
		if( eventKey.isControlDown() )   // key + <ctrl>
		{
			controlMove(keyCode);
		}
		else if( eventKey.isShiftDown() ) // key + <shift>
		{
			shiftMove(keyCode);
		}
		else if( keyCode == quitKey )
		{
			System.exit(0);
		}
		else
		{
			standardMove(keyCode);
		}
	}
	
	private void controlMove(int keyCode)
	{
		if(keyCode == backKey) 
		{  // move down
			moveBy(VDOWN,0);
		}
		else if(keyCode == forwardKey) 
		{  // move up
			moveBy(VUP,0);
		}
		else if(keyCode == leftKey)
		{
			moveBy(VLEFT,0);
		}
		else if(keyCode == rightKey)
		{
			moveBy(VRIGHT,0);
		}
		else if (keyCode == fireKey)
		{
			ammoManager.fireTrap();
		}
	}
	
	private void shiftMove(int keyCode) 
	{
		if (keyCode == fireKey)
		{
			ammoManager.fireEnchant();
		}
	}

	private void standardMove(int keyCode)
	{
		if(keyCode == forwardKey)
			moveBy(VFWD,0);
		else if(keyCode == backKey)
			moveBy(VBACK,0);
		else if(keyCode == leftKey)
			doRotateY(ROT_AMT);
		else if(keyCode == rightKey)
			doRotateY(-ROT_AMT);/*
		else if(keyCode == lookUp)
		{
			if ((angleFromHorizontal+ROT_AMT) <= (Math.PI/2)) 
			{ // Won't let you look up further than straight up
				angleFromHorizontal += ROT_AMT;
				doRotateX(ROT_AMT);
			}
		}
		else if(keyCode == lookDown)
		{ // Won't let you look down further than straight down
			if ((angleFromHorizontal-ROT_AMT) >= -(Math.PI/2)) 
			{
				angleFromHorizontal -= ROT_AMT;
				doRotateX(-ROT_AMT);
			}
		}// */
		else if (keyCode == fireKey)
		{
			ammoManager.fireRanged();
		}
	}
	
	private void moveBy(Vector3d theMove, int counter)
	/* Calculate the next move and test if there is an obstacle there.
	   If there isn't then carry out the move, otherwise issue a
	   warning. */
	{
		targetTG.getTransform(transform3d); // *** note about targetTG ***
											// targetTG is part of the class that is extended, so I cannot
											// change the name.  The TG refers to TransformGroup.
											// targetTG is the transform group associated with the player's view
		log.println("theMove is: "+theMove.toString());
		Vector3d nextLocation = possibleMove(theMove);
		log.println("nextLocation is: ("+nextLocation.x+","+nextLocation.y+","+nextLocation.z+")");
		boolean canMove = terrain.canMoveTo(nextLocation);
		if(!canMove)
		{	
			// the path is heading out of bounds.  Since the player should never get close to the bounds,
			// stop them immediately, do not slide.
		}
		else 
		{	// no obstacle there?
			targetTG.setTransform(transform3d);   
			// transform3d is a global set in possibleMove()
		}
	}
	
	private Vector3d possibleMove(Vector3d theMove)
	/* Calculate the effect of the given translation but
	   do not update the object's position until it's been
	   tested. */
	{ 
		targetTG.getTransform(transform3d);   // targetTG is the ViewPlatform's transform
		toMove.setTranslation(theMove);       // sets up a transformation matrix
		transform3d.mul(toMove);              // multiplies the ViewPlatform's transform matrix by the new transformation matrix
		transform3d.get(transformedVector);     // gets the new vector from the modified transform matrix
		return transformedVector;
	}
	
	private void doRotateY(double radians)
	{
		targetTG.getTransform(transform3d);   // rotate player left and right
		toRot.rotY(radians);
		transform3d.mul(toRot);
		targetTG.setTransform(transform3d);
		rotated += radians;
		if(rotated > Math.PI*2)
			rotated = 0;
	}
	
	private void doRotateX(double radians)
	{
		targetTG.getTransform(transform3d);   // rotate player up and down (currently disabled)
		toRot.rotX(radians);
		transform3d.mul(toRot);
		targetTG.setTransform(transform3d);
	}

	@Override
	protected void integrateTransforms() {}

	@Override
	protected void processAWTEvents(AWTEvent[] arg0) {}
}
