package main;
// AmmoManager.java
// Andrew Davison, May 2003, dandrew@ratree.psu.ac.th

/* AmmoManager starts by loading a predetermined set of explosion images
	 into exploIms[].

	 It then creates NUMBEAMS LaserShot objects, and passes a reference
	 to the array to each one. This means that the images are only loaded
	 once, rather than NUMBEAMS times.

	 AmmoManager also handles a fireBeam() call from KeyBehavior by firing 
	 a beam if one is available, otherwise doing nothing.
*/

import javax.media.j3d.BranchGroup;
import javax.media.j3d.TransformGroup;

import objects.DynamicObjectManager;
import objects.Factories.Factory;
import objects.Spells.Spell;
import utils.Logger;

public class AmmoManager
{
	private final static int NUMBER_OF_SPELLS = 20;
	
	private Spell[] shots;		// for the ranged
	private Logger log;
	private int firingCounter = 0;
	
	public AmmoManager(TransformGroup steerTransformGroup, BranchGroup sceneBranchGroup, TerrainManager terrain, String type, Logger log, DynamicObjectManager objectManager)
	{
		this.log = log;
		shots = new Spell[NUMBER_OF_SPELLS];
		for(int i=0; i < NUMBER_OF_SPELLS; i++) 
		{
			shots[i] = Factory.getSpell(steerTransformGroup, type, terrain, log, objectManager);
			// a laser shot represents a single beam and explosion
			sceneBranchGroup.addChild( shots[i].getTransformGroup() );
		}
	}	// end of AmmoManager()


	public void fireRanged()
	// fire an available beam (called from KeyAndMouseBehavior)
	{ 
		firingCounter++;
		boolean testing = false;
		for(int i=0; i < NUMBER_OF_SPELLS; i++) 
		{
			if( testing=shots[i].requestFiring( Spell.RANGED ) ) // If the Spell object isn't in use, fire the spell in the specified mode, 
											  // else go to the next in the array and check that instance of Spell 
			{
				log.println(firingCounter+" shot "+i+" is in use:"+testing);
				return;
			}
			log.println(firingCounter+" shot "+i+" is in use:"+testing);
		}
	}	// end of fireRanged()
	
	public void fireTrap()
	// fire an available beam (called from KeyAndMouseBehavior)
	{ 
		for(int i=0; i < NUMBER_OF_SPELLS; i++) 
		{
			if( shots[i].requestFiring( Spell.TRAP ) ) 
			{
				return;
			}
		}
	}	// end of fireTrap()
	
	public void fireEnchant()
	// fire an available beam (called from KeyAndMouseBehavior)
	{ 
		for(int i=0; i < NUMBER_OF_SPELLS; i++) 
		{
			if( shots[i].requestFiring( Spell.ENCHANT ) ) 
			{
				return;
			}
		}
	}	// end of fireEnchant()


	public int getAllDamage() {
		// TODO this collects all the damage done from the Traps and the Explosions
		return 0;
	}
}	// end of AmmoManager class

