package objects.Effects;

import java.util.ArrayList;

import javax.media.j3d.Appearance;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.Switch;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;

import objects.CollisionDetector;
import objects.DynamicObject;
import objects.DynamicObjectManager;
import objects.Spells.Spell;
import utils.Logger;

import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;

public class Explosion implements DynamicObject
{
	private static final int DELAY = 100;   // milliseconds delay between display of spheres
	private Switch explosion;
	private Texture2D flames;
	private String type;
	private Logger log;

	public Explosion( float size, String type, DynamicObjectManager objectManager ) 
	{
		this.type = type;
		TextureLoader loader = new TextureLoader("./images/"+type+".jpg", null);
	    flames = (Texture2D) loader.getTexture();
		createObject( size );
		createAppearance();
	}
	
	public Switch getExplosion()
	{
		return explosion;
	}

	private void createAppearance() 
	{
		Sphere temporaryPointer;
		Appearance tempAppearance = null;
		float colorRatio = 1.0f;
		for(int counter = 0;counter < explosion.numChildren();counter++)
		{
			tempAppearance = new Appearance();
			
			// mix the texture and the material color
		    TextureAttributes textureAttributes = new TextureAttributes();
		    textureAttributes.setTextureMode(TextureAttributes.MODULATE);
		    tempAppearance.setTextureAttributes(textureAttributes);
		    tempAppearance.setTexture(flames);
		    
		    // add a colored material
		    Material material = new Material(new Color3f(.5f,colorRatio,0), new Color3f(.5f,colorRatio,0), 
		    		new Color3f(.5f,colorRatio,0), new Color3f(1,1,1), 0f);
		    material.setLightingEnable(true);
		    tempAppearance.setMaterial(material);
		    
		    colorRatio -= colorRatio/2;
		    
			temporaryPointer = (Sphere) explosion.getChild(counter);
			temporaryPointer.setAppearance(tempAppearance);
		}
	}

	private void createObject(float size) 
	{
		// create switch for visibility
	    explosion = new Switch();
	    explosion.setCapability(Switch.ALLOW_SWITCH_WRITE);
	    explosion.setUserData( this );

	    float step = size/4;
	    for(int counter = 0;counter < 5 && step < size;counter++)
	    {
	    	explosion.addChild( new Sphere( step, Sphere.GENERATE_TEXTURE_COORDS|Sphere.GENERATE_NORMALS_INWARD, 36 ) );
	    	explosion.setWhichChild( Switch.CHILD_NONE );   // invisible initially
	    	step += step/2;
	    }
	}
	
	public void showSeries()
	{
		for (int i=0; i < explosion.numChildren(); i++) 
		{
			explosion.setWhichChild(i);
			
			try 
			{
				Thread.sleep(DELAY);      // wait a while
			} 
			catch (Exception e) {}
		}
		explosion.setWhichChild(Switch.CHILD_NONE);
	} // end of showSeries()

	Transform3D location = new Transform3D();
	Vector3d thisPosition = new Vector3d();
	@Override
	public Vector3d getPosition() 
	{
		getExplosion().getLocalToVworld( location );
		location.get(thisPosition);
		return thisPosition;
	}

	@Override
	public double getRange() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public int doDamage(int[] damage) 
	{
		return 0;
		// nothing here, since you can't do damage to an explosion.
	}

	@Override
	public String getName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void collidingEffectOn(DynamicObject data) {
		// TODO Auto-generated method stub
		
	}
}
