
import java.awt.Container;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import main.Controller;
import utils.Logger;

public class Start extends JFrame
{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public Start(String[] args) 
	{
		String fileName = null;
		Logger log = null;
		
		if (args.length == 2)
		{
			fileName = args[0];
			log = new Logger(Integer.parseInt(args[1]));
		}
		else if (args.length == 1)
	    {
	      fileName = args[0];
	      log = new Logger( Logger.NONE );//Logger.ALL);
	    }
	    else if (args.length == 0)
	    {
	      fileName = "maze_2";  // default maze file
	      log = new Logger(255); // default logging level
	    }
	    else {
	      System.out.println( "Usage: java Maze3D <fileName> <loggerLevel>\n"+Logger.printLevels());
	      System.exit(0);
	    }
		setUndecorated(true);

	    Controller world3d = new Controller( fileName, log );

	    Container container = getContentPane();
	    container.setLayout( new BoxLayout(container, BoxLayout.X_AXIS) );
	    container.add(world3d);   // main camera pane

	    setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );
	    pack();
	    setResizable(false);    // fixed size display
	    setVisible(true);
	  } // end of Maze3D()

	/**
	 * @param args
	 */
	public static void main(String[] args)
	{
		new Start(args);
	}

}
