# models.py
# This file describes models and their behavior.
#
#
# future note: deal with situation when __unicode__() is called but FK is not set yet.

from django.db import models
from django.forms import ModelForm
from django.contrib.auth.models import User
from django.conf import settings
from django import forms
from PIL import Image
from photosite.photoapp import custom_models
from django.template.defaultfilters import slugify
import os

# instance filename
def get_upload_path(subfolder):
	"""Generates upload path for ImageField. 
	It smuggles subfolder variable into upload_callback
	which is called by Django. This is the only way to
	get any outside varable into upload_to callable."""
	
	def upload_callback(instance, filename):
		""" This function returns file path constructed for upload_to"""
		return os.path.join('uploads', instance.author.username, subfolder, filename)
	
	return upload_callback

class Picture(models.Model):
	name = models.CharField(max_length=30)
	date = models.DateTimeField(auto_now_add=True) # Date and time when the picture was uploaded
	main_pic = custom_models.ResizedImageField(upload_to=get_upload_path('main_pictures'), max_width=200, max_height=200, format='JPEG')
	thumbnail = custom_models.ResizedImageField(upload_to=get_upload_path('thumbnails'), format='JPEG')
	
	rating = models.PositiveIntegerField(blank=True, null=True) # for values and dates must set blank and null to true to allow blank values
	keywords = models.TextField(blank=True)
	rf = models.BooleanField() #license type
	rm = models.BooleanField() #license type
	# reletionship field
	author = models.ForeignKey(User)
	
	def __unicode__(self):
		return self.name
	
	
	
class Print(models.Model):
	size = models.CharField(max_length = 15)
	price = models.DecimalField(max_digits = 10, decimal_places=2);
	# reletionship fields
	pic = models.ForeignKey(Picture) # Picture to print
	
	def __unicode__(self):
		return u'%s size: %s' % (self.pic.name, self.size)

class Category(models.Model):
	name = models.CharField(max_length=30, unique=True)
	
	def __unicode__(self):
		return self.name
	
class Picture_category(models.Model):
	# reletionship fields	
	pic = models.ForeignKey(Picture)
	category = models.ForeignKey(Category)
	
	def __unicode__(self):
		return u'%s in %s' % (self.pic.name, self.category.name)

class Comment(models.Model):
	date = models.DateTimeField() # Date of the comment
	text = models.TextField() # text of the comment
	
	# reletionship fields
	author = models.ForeignKey(User) # Author of the comment
	pic	= models.ForeignKey(Picture) # Targeted picture
	
	def __unicode__(self):
		return u'%s about %s' % (self.author.username, self.pic.name)

class RecommendedPicture(models.Model):
	date = models.DateTimeField(auto_now_add=True) # Date of the recomendation
	
	# reletionship fields
	author = models.ForeignKey(User) # Author who recommended
	pic	= models.ForeignKey(Picture) # picture which was recommeded
	
	def __unicode__(self):
		return u'%s recomends %s' % (self.author.username, self.pic.name)

class Blog(models.Model):
	text = models.TextField() # txt of the blog post
	date = models.DateTimeField(auto_now=True) # Date and time when it was last updated
	
	# reletionship fields
	author = models.ForeignKey(User) # Author of the blog
	
	def __unicode__(self):
		return self.author.username

class PictureForm(ModelForm):
	#main_pic = forms.ImageField(label='Upload picture:')
	class Meta:
		model = Picture
		fields = ['main_pic', 'name', 'keywords', 'rating', 'rf', 'rm']
		#exclude = ['']

#######################################################################################################

	
