﻿using GuitarTrainer.Interfaces;

namespace GuitarTrainer.Sound
{
    interface ISoundPlayer
    {
        /// <summary>
        /// Create a performance object that is compatible with this class of ISoundPlayer
        /// </summary>
        /// <param name="tracks">The number of physical tracks in the performance</param>
        /// <param name="tempo">The tempo at which to play it</param>
        /// <param name="resolution">The resolution in tick per quarter note</param>
        /// <returns></returns>
        IPerformance createPerformance(int tracks, Tempo tempo, int resolution);

        void start();

        void close();

        IPerformance Performance
        {
            set;
        }
    }
}
