﻿using GuitarTrainer.Interfaces;

namespace GuitarTrainer.Sound
{
    abstract class PerformanceTimerEvent : PerformanceEvent
    {
        private readonly ISongMeasure measure;
        private readonly int beat;
        private readonly int division;
        private readonly int totalDivisions;

        protected PerformanceTimerEvent(EventStream es, int offset, ISongMeasure measure, int beat, int division, int totalDivisions)
            : base(es, offset)
        {
            this.measure = measure;
            this.beat = beat;
            this.division = division;
            this.totalDivisions = totalDivisions;
        }

        public int Beat
        {
            get { return beat; }
        }
        public int Division
        {
            get { return division; }
        }
        public int Measure
        {
            get { return measure.getIndex(); }
        }
        public int TotalBeats
        {
            get { return measure.getTimeSignature().Denominator; }
        }
        public int TotalDivisions
        {
            get { return totalDivisions; }
        }
    }
}
