﻿namespace GuitarTrainer.Sound
{
    class PerformanceEvent
    {
        /// <summary>
        /// The EventStream within which this performance event lies
        /// </summary>
        EventStream eventStream;

        /// <summary>
        /// The time offset into the performance, in resolution units
        /// </summary>
        readonly int offset;

        protected PerformanceEvent(EventStream stream, int offset)
        {
            eventStream = stream;
            this.offset = offset;
            Next = null;
        }

        public PerformanceEvent Next { get; set; }
    }
}
