﻿namespace GuitarTrainer.Interfaces
{
    /// <summary>
    /// A tempo is usually expressed in one of two different varieties:
    /// Beats per Minute (BPM) and Microseconds per Quarter Note.
    /// This class converts between the two
    /// </summary>
    class Tempo
    {
        private static string className = "Tempo";
        private const double ONE_MINUTE_IN_MICROSECONDS = 60.0 * 1000.0 * 1000.0;

        private int beat = 4;
        private double bpm = 120;
        private double usq = 500000;

        public int Beat
        {
            get { return beat; }
            set
            {
                beat = value;
                recalculateUSQ();
            }
        }

        public double BPM
        {
            get { return bpm; }
            set
            {
                bpm = value;
                recalculateUSQ();
            }
        }

        public double USQ
        {
            get { return usq; }
            set
            {
                usq = value;
                recalculateBPM();
            }
        }

        private void recalculateUSQ()
        {
            // Turn BPM into Quarter Notes per Second
            double quaterPerMinute = (bpm * 4.0) / beat;

            usq = ONE_MINUTE_IN_MICROSECONDS / quaterPerMinute;
        }

        private void recalculateBPM()
        {
            // Turn Quarter Notes per Second into BPM
            double quarterPerMinute = ONE_MINUTE_IN_MICROSECONDS / usq;
            bpm = (quarterPerMinute * beat) / 4.0;
        }
    }
}
