﻿namespace GuitarTrainer.Interfaces
{
    /// <summary>
    /// A ISongTrack defines the initialization events of a track 
    /// (like a program change or controller settings)
    /// </summary>
    interface ISongTrack
    {

        ISongDevice PrimaryDevice
        {
            get;
            set;
        }

        ISongDevice SecondaryDevice
        {
            get;
            set;
        }

        int Program
        {
            get;
            set;
        }

        int Volume
        {
            get;
            set;
        }

        int Pan
        {
            get;
            set;
        }

        int Chorus
        {
            get;
            set;
        }

        int Reverb
        {
            get;
            set;
        }

        int Tremolo
        {
            get;
            set;
        }

        int Phaser
        {
            get;
            set;
        }

        int BendSensitivity
        {
            get;
            set;
        }

        int VirtualTrackCount
        {
            get;
        }

        int Index
        {
            get;
        }
    }
}
