﻿using System.Collections;
using GuitarTrainer.GuitarProComponents;

namespace GuitarTrainer.Interfaces
{
    static class DynamicsHash
    {
        private static readonly Hashtable dynamicsHash = createDynamicsHash();

        private static Hashtable createDynamicsHash()
        {
            Hashtable hash = new Hashtable
                                 {
                                     {"PPP", 16},
                                     {"PP", 32},
                                     {"P", 47},
                                     {"MP", 63},
                                     {"MF", 79},
                                     {"F", 95},
                                     {"FF", 111},
                                     {"FFF", 127}
                                 };

            return hash;
        }

        public static int velocityOf(GPDynamic dynamic)
        {
            int velocity = 95;
            if (dynamic != null)
            {
                string stringVal = dynamic.toString();
                velocity = (int)dynamicsHash[stringVal];
            }
            return velocity;
        }
    }
}
