﻿using System.Collections.Generic;
using GuitarTrainer.Interfaces;

namespace GuitarTrainer.InterfaceImpl
{
    class SongVirtualTrackImpl : ISongVirtualTrack
    {
        private readonly ISongMeasureTrack track;
        private readonly int index;
        readonly List<ISongEvent> events;

        public SongVirtualTrackImpl(ISongMeasureTrack track, int index)
        {
            this.track = track;
            this.index = index;
            events = new List<ISongEvent>();
        }

        #region ISongVirtualTrack Members

        public ISongMeasureTrack MeasureTrack
        {
            get { return track; }
        }

        public int Index
        {
            get { return index; }
        }

        public void addEvent(ISongEvent e)
        {
            e.VirtualTrack = this;
            events.Add(e);
        }

        public void addEvents(List<ISongEvent> newEvents)
        {
            foreach (ISongEvent se in newEvents)
                events.Add(se);
        }

        public List<ISongEvent> Events
        {
            get { return events; }
        }

        #endregion
    }
}
