﻿namespace GuitarTrainer.InterfaceImpl
{
    class SongNotationMessage : SongMessageImpl
    {
        private int duration;

        protected SongNotationMessage(int duration)
        {
            this.duration = duration;
        }

        public override bool Equals(object obj)
        {
            if (!(obj is SongNotationMessage))
                return false;
            
            SongNotationMessage snm = (SongNotationMessage) obj;
            return (duration == snm.duration);
        }

        public override string ToString()
        {
            return "D" + duration;
        }

        public int Duration
        {
            get { return duration; }
            set { this.duration = value; }
        }
    }
}
