﻿namespace GuitarTrainer.GuitarProComponents
{
    // The class that describes a vibrato
    class GPVibrato
    {
        // A vibrato is represented by an integer
        private readonly int type;

        // The vibrato types that this class accepts
        public static readonly GPVibrato none = new GPVibrato(0);
        public static readonly GPVibrato fast = new GPVibrato(1);
        public static readonly GPVibrato average = new GPVibrato(2);
        public static readonly GPVibrato slow = new GPVibrato(3);

        // The vibratos
        private static readonly GPVibrato[] vibratos = { none, fast, average, slow };

        // The vibratos' names
        private static readonly string[] vibratosNames = { "None", "Fast", "Average", "Slow" };

        /// <summary>
        /// Creates a new vibrato whos type is the parameter 'type'
        /// </summary>
        /// <param name="type">The type of vibrato to create</param>
        private GPVibrato(int type)
        {
            this.type = type;
        }

        /// <summary>
        /// Returns the vibrato of the index
        /// </summary>
        /// <param name="type">The index of the vibrato wanted</param>
        /// <returns>Returns the vibrato associated with the value of the parameter 'type'</returns>
        public static GPVibrato valueOf(int type)
        {
            return vibratos[type];
        }

        /// <summary>
        /// The string representation of this object
        /// </summary>
        /// <returns>Returns the string representation of this object</returns>
        public override string ToString()
        {
            return vibratosNames[type];
        }
    }
}
