﻿namespace GuitarTrainer.GuitarProComponents
{
    /// <summary>
    /// Describes a track belonging to the piece that has been read in
    /// </summary>
    class GPTrack
    {
        // Whether this track is a drums only track
        public bool isDrumsTrack;

        // Whether this track is a 12-stringed guitar only track
        public bool is12StringedGuitarTrack;

        // Whether this track is a banjo track
        public bool isBanjoTrack;

        // The capo number (if present)
        private int capo;

        // The MIDI channel used
        private int channel;

        // The  MIDI channel used for various effects
        private int channelEffects;

        // The track's color
        private GPColor color;

        // The track's name
        private string name;

        // The number of frets of the track's instrument
        private int numberOfFrets;

        // The number of strings in the track
        private int numberOfStrings;

        // The MIDI port used in the track
        private int port;

        // The track's instrument tuning;
        private readonly int[] stringsTuning;

        /// <summary>
        /// Default constructor. Creates a new track.
        /// </summary>
        public GPTrack()
        {
            capo = 0;
            channel = 0;
            channelEffects = 0;
            color = new GPColor();
            is12StringedGuitarTrack = false;
            isBanjoTrack = false;
            isDrumsTrack = false;
            name = "";
            numberOfFrets = 0;
            numberOfStrings = 6;
            port = 0;
            stringsTuning = new int[7];
        }

        /// <summary>
        /// String representation of this object
        /// </summary>
        /// <returns>A string that represents this object</returns>
        public override string ToString()
        {
            string toReturn = "";

            toReturn += "\tDrums track? " + isDrumsTrack;
            toReturn += "\n\t12-stringed guitar track? " + is12StringedGuitarTrack;
            toReturn += "\n\tBanjo track? " + isBanjoTrack;
            toReturn += "\n\tName: " + name;
            toReturn += "\n\tNumber of strings: " + numberOfStrings;

            toReturn += "\n\tTuning: ";
            for (int i = 0; i < numberOfStrings; i++)
                toReturn += stringsTuning[i] + " ";

            toReturn += "\n\tPort: " + port;
            toReturn += "\n\tChannel: " + channel;
            toReturn += "\n\tChannel effects: " + channelEffects;
            toReturn += "\n\tNumber of frets: " + numberOfFrets;
            toReturn += "\n\tHeight of the capo: " + capo;
            toReturn += "\n\tColor: " + color.toString();

            return toReturn;
        }

        #region Getters & Setters
        public int Capo
        {
            get { return capo; }
            set { capo = value; }
        }
        public int Channel
        {
            get { return channel; }
            set { channel = value; }
        }
        public int ChannelEffects
        {
            get { return channelEffects; }
            set { channelEffects = value; }
        }
        public GPColor Color
        {
            get { return color; }
            set { color = value; }
        }
        public string Name
        {
            set { name = value; }
        }
        public int NumberOfFrets
        {
            set { numberOfFrets = value; }
        }
        public int NumberOfStrings
        {
            get { return numberOfStrings; }
            set { numberOfStrings = value; }
        }
        public int Port
        {
            get { return port; }
            set { port = value; }
        }
        public int getStringsTuning(int i)
        {
            return stringsTuning[i];
        }
        public void setStringsTuning(int i, int stringsTuning)
        {
            this.stringsTuning[i] = stringsTuning;
        }
        #endregion
    }
}
