﻿namespace GuitarTrainer.GuitarProComponents
{
    /// <summary>
    /// The class that describes a pick stroke
    /// </summary>
    class GPPickStroke
    {
        // A pickstroke is represented by an integer
        private readonly int type;

        // The pickstroke types this class accepts
        public static readonly GPPickStroke none = new GPPickStroke(0);
        public static readonly GPPickStroke upward = new GPPickStroke(1);
        public static readonly GPPickStroke downward = new GPPickStroke(2);

        // The pick strokes
        private static readonly GPPickStroke[] pickStrokes = { none, upward, downward };

        // The pick strokes in string format
        private static readonly string[] pickStrokesNames = { "None", "Upward", "Downard" };

        /// <summary>
        /// Create a new pick stroke type whose type is the argument 'type'
        /// </summary>
        /// <param name="type">The type to make this pickstroke</param>
        private GPPickStroke(int type)
        {
            this.type = type;
        }

        /// <summary>
        /// Returns the pick stroke associated with the value of the argument 'type'
        /// </summary>
        /// <param name="type">The index of the pick stroke to look up</param>
        /// <returns>The pick stroke that the index represents</returns>
        public static GPPickStroke valueOf(int type)
        {
            return pickStrokes[type];
        }

        public string toString()
        {
            return pickStrokesNames[type];
        }
    }
}
