﻿namespace GuitarTrainer.GuitarProComponents
{
    /// <summary>
    /// This class describes how a complete note is represented.
    /// Contrarily to the GPMusicalNote class, this one carries out the
    /// information contained about one note in Guitar Pro, it can have
    /// effects, be accentuated, etc
    /// </summary>
    class GPNote
    {
        // A note duration possibly linked to this note
        private GPDuration duration;

        // Effects possibly linked to this note
        private GPEffectsOnNote effects;

        // Fingering on the left & right hand possibly linked to this note.
        private GPFingering fingeringLeftHand;
        private GPFingering fingeringRightHand;

        // Whether the note is accentuated
        private bool isAccentuated;

        // Whether the note is dotted
        private bool isDotted;

        // The note dynamic
        private GPDynamic dynamic;

        // The fret number
        private int fretNumber;

        // Whether the note is a dead note (ie muted, represented as an 'X' on tablature)
        private bool isDeadNote;

        // Whether the note is a ghost note
        private bool isGhostNote;

        // Whether the note is a tied note
        private bool isTieNote;

        // The n-tuplet this note may take part in
        private int nTuplet;

        /// <summary>
        /// Default constructor. Creates a new note.
        /// </summary>
        public GPNote()
        {
            duration = null;
            dynamic = GPDynamic.f;
            effects = null;
            fingeringLeftHand = null;
            fingeringRightHand = null;
            fretNumber = 0;
            isAccentuated = false;
            isDeadNote = false;
            isDotted = false;
            isGhostNote = false;
            isTieNote = false;
            nTuplet = 0;
        }

        /// <summary>
        /// Tests whether or not an object is equal to this instance
        /// </summary>
        /// <param name="o">The object ot test</param>
        /// <returns>Returns true if the given object is equal to this</returns>
        public override bool Equals(object o)
        {
            GPNote other;
            bool toReturn = false;

            if ((o != null) && (o.GetType().IsInstanceOfType(this)))
            {
                other = (GPNote)o;
                toReturn = fretNumber == other.fretNumber;
                toReturn = toReturn && (nTuplet == other.nTuplet);
                toReturn = toReturn && (isDeadNote == other.isDeadNote);
                toReturn = toReturn && (isGhostNote == other.isGhostNote);
                toReturn = toReturn && (isTieNote == other.isTieNote);

                if (duration != null)
                    toReturn = duration.Equals(other.duration);
            }

            return toReturn;
        }

        /// <summary>
        /// Returns a string representation of the Note
        /// </summary>
        /// <returns>The string representation of this object</returns>
        public override string ToString()
        {
            string toReturn = "";

            if (duration != null)
                toReturn += "Duration: " + duration;
            if (dynamic != null)
                toReturn += ", Dynamic: " + dynamic.toString();
            if (effects != null)
                toReturn += ", Effects: " + effects;
            if (fingeringLeftHand != null)
                toReturn += ", fingeringLeftHand : " + fingeringLeftHand;
            if (fingeringRightHand != null)
                toReturn += ", fingeringRightHand : " + fingeringRightHand;
            if (isAccentuated)
                toReturn += ", isAccentuated";
            if (isDeadNote)
                toReturn += ", isDeadNote";
            if (isDotted)
                toReturn += ", isDotted";
            if (isGhostNote)
                toReturn += ", isGhostNote";
            if (isTieNote)
                toReturn += ", isTieNote:";
            toReturn += ", nTuplet" + ": " + nTuplet;
            toReturn += ", fret number:" + fretNumber;

            return toReturn;
        }

        #region Getters and setters
        public int NTuplet
        {
            get { return nTuplet; }
            set { nTuplet = value; }
        }
        public bool IsGhostNote
        {
            set { isGhostNote = value; }
        }
        public bool IsDeadNote
        {
            set { isDeadNote = value; }
        }
        public bool IsTieNote
        {
            get { return isTieNote; }
            set { isTieNote = value; }
        }
        public int FretNumber
        {
            get { return fretNumber; }
            set { fretNumber = value; }
        }
        public GPDynamic Dynamic
        {
            get { return dynamic; }
            set { dynamic = value; }
        }
        public bool IsDotted
        {
            get { return isDotted; }
            set { isDotted = value; }
        }
        public bool IsAccentuated
        {
            set { isAccentuated = value; }
        }
        public GPDuration Duration
        {
            get { return duration; }
            set { duration = value; }
        }
        public GPEffectsOnNote Effects
        {
            get { return effects; }
            set { effects = value; }
        }
        public GPFingering FingeringLeftHand
        {
            set { fingeringLeftHand = value; }
        }
        public GPFingering FingeringRightHand
        {
            set { fingeringRightHand = value; }
        }
        #endregion
    }
}
