﻿namespace GuitarTrainer.GuitarProComponents
{
    /// <summary>
    /// Class that describes a mix table change
    /// </summary>
    class GPMixTableChange
    {
        // Gives the changes about various parts of the song
        public GPMixTableElement balance;
        public GPMixTableElement chorus;
        public GPMixTableElement instrument;
        public GPMixTableElement phaser;
        public GPMixTableElement reverb;
        public GPMixTableElement tempo;
        public GPMixTableElement tremolo;
        public GPMixTableElement volume;

        /// <summary>
        /// Creates a new mix table change
        /// </summary>
        public GPMixTableChange()
        {
            balance = null;
            chorus = null;
            instrument = null;
            phaser = null;
            reverb = null;
            tempo = null;
            tremolo = null;
            volume = null;
        }

        /// <summary>
        /// Returns a string representation for this mix table
        /// </summary>
        /// <returns>The string representation of this class</returns>
        public string toString()
        {
            string toReturn = "empty MixTableChange";

            if (balance != null)
                toReturn = "balance" + ": " + balance.ToString();
            if (chorus != null)
                toReturn += ", chorus" + ": " + chorus.ToString();
            if (instrument != null)
                toReturn += ", instrument" + ": " + instrument.ToString();
            if (phaser != null)
                toReturn += ", phaser" + ": " + phaser.ToString();
            if (reverb != null)
                toReturn += ", reverb" + ": " + reverb.ToString();
            if (tempo != null)
                toReturn += ", tempo" + ": " + tempo.ToString();
            if (tremolo != null)
                toReturn += ", tremolo" + ": " + tremolo.ToString();
            if (volume != null)
                toReturn += ", volume" + ": " + volume.ToString();

            return toReturn;
        }
    }
}
