﻿namespace GuitarTrainer.GuitarProComponents
{
    /// <summary>
    /// Class describes a marker used in the piece
    /// </summary>
    class GPMarker
    {
        /// <summary>
        /// Create a new marker
        /// </summary>
        public GPMarker()
        {
            Color = new GPColor();
            Name = "";
        }

        /// <summary>
        /// Return a string representation of this marker
        /// </summary>
        /// <returns>The string representation of this</returns>
        public override string ToString()
        {
            string toReturn = "Name : " + Name;
            toReturn += "\nColor: " + Color;

            return toReturn;
        }

        // The marker's color
        public GPColor Color { private get; set; }
        // The marker's name
        public string Name { private get; set; }
    }
}
