﻿namespace GuitarTrainer.GuitarProComponents
{
    // Describes a MIDI channel used in the piece
    class GPMIDIChannel
    {
        // The balance of the MIDI channel
        private int balance;

        // The chorus of the MIDI channel
        private int chorus;

        // The instrument of the MIDI channel
        private int instrument;

        // The phaser of the MIDI channel
        private int phaser;

        // The reverb of the MIDI channel
        private int reverb;

        // The tremolo of the MIDI channel
        private int tremolo;

        // The volume of the MIDI channel
        private int volume;

        /// <summary>
        /// Creates a new MIDI channel
        /// </summary>
        public GPMIDIChannel()
        {
            balance = 0;
            chorus = 0;
            instrument = 0;
            phaser = 0;
            reverb = 0;
            tremolo = 0;
            volume = 0;
        }

        /// <summary>
        /// The string representation of this class
        /// </summary>
        /// <returns>Returns the string representation of this</returns>
        public override string ToString()
        {
            string toReturn = "Instrument: " + instrument;
            toReturn += ", Volume: " + volume;
            toReturn += ", Balance: " + balance;
            toReturn += ", Chorus: " + chorus;
            toReturn += ", Reverb: " + reverb;
            toReturn += ", Phaser: " + phaser;
            toReturn += ", Tremolo: " + tremolo + "\n";

            return toReturn;
        }

        #region Getters and setters
        public int Balance
        {
            get { return balance; }
            set { balance = value; }
        }
        public int Volume
        {
            get { return volume; }
            set { volume = value; }
        }
        public int Tremolo
        {
            get { return tremolo; }
            set { tremolo = value; }
        }
        public int Reverb
        {
            get { return reverb; }
            set { reverb = value; }
        }
        public int Phaser
        {
            get { return phaser; }
            set { phaser = value; }
        }
        public int Instrument
        {
            get { return instrument; }
            set { instrument = value; }
        }
        public int Chorus
        {
            get { return chorus; }
            set { chorus = value; }
        }
        #endregion
    }
}
