﻿namespace GuitarTrainer.GuitarProComponents
{
    /// <summary>
    /// Describes the fingering of a chord
    /// </summary>
    class GPFingering
    {
        // A fingering is represented as an integer
        private int type;

        // All the fingering this class allows
        public static readonly GPFingering unknown = new GPFingering(-2);
        public static readonly GPFingering noFinger = new GPFingering(-1);
        public static readonly GPFingering thumb = new GPFingering(0);
        public static readonly GPFingering index = new GPFingering(1);
        public static readonly GPFingering middleFinger = new GPFingering(2);
        public static readonly GPFingering ringFinger = new GPFingering(3);
        public static readonly GPFingering littleFinger = new GPFingering(4);

        // All the fingerings allowed
        private static readonly GPFingering[] fingerings = { 
                 unknown, noFinger, thumb, index, 
                 middleFinger, ringFinger, littleFinger };

        // The fingerings' names in string format
        private static readonly string[] fingeringsNames  = {
                "Unknown", "No finger", "Thumb","Index", 
                "Middle finger", "Ring finger", "Little finger" };

        /// <summary>
        /// Create a new finger shoe type is the argument 'type'
        /// </summary>
        /// <param name="type">The index of the fingering to look up</param>
        private GPFingering(int type)
        {
            this.type = type;
        }

        /// <summary>
        /// Returns the fingering associated with the value of the argument 'type'
        /// </summary>
        /// <param name="type">The index of the fingering to look up</param>
        /// <returns>The fingering the index represents</returns>
        public static GPFingering valueOf(int type)
        {
            return fingerings[type + 2];
        }

        /// <summary>
        /// Returns a string representation of a fingering
        /// </summary>
        /// <returns>The string representation of this</returns>
        public string toString()
        {
            return fingeringsNames[type + 2];
        }
    }
}
