﻿namespace GuitarTrainer.GuitarProComponents
{
    /// <summary>
    /// The class that describes a note's dynamic
    /// </summary>
    class GPDynamic
    {
        // A note's dynamic is represented by an integer
        private readonly int type;

        // An invalid dynamic value
        public static readonly GPDynamic invalid = new GPDynamic(0);
        // Piano pianissimo
        public static readonly GPDynamic ppp = new GPDynamic(1);
        // Pianissimo
        public static readonly GPDynamic pp = new GPDynamic(2);
        // Piano
        public static readonly GPDynamic p = new GPDynamic(3);
        // Mezzo piano
        public static readonly GPDynamic mp = new GPDynamic(4);
        // Mezzo forte
        public static readonly GPDynamic mf = new GPDynamic(5);
        // Forte
        public static readonly GPDynamic f = new GPDynamic(6);
        // Fortissimo
        public static readonly GPDynamic ff = new GPDynamic(7);
        // Forte fortissimo
        public static readonly GPDynamic fff = new GPDynamic(8);

        // The different dynamics
        private static readonly GPDynamic[] dynamics = { invalid, ppp, pp, p, mp, mf,
            f, ff, fff };

        // The different dynamics in string format
        private static readonly string[] dynamicsName = { "Invalid", "PPP", "PP",
            "P", "MP", "MF", "F", "FF", "FFF" };

        /// <summary>
        /// Create a new dynamic whose type is the value of the argument 'type'
        /// </summary>
        /// <param name="type">The type of dynamic to create</param>
        private GPDynamic(int type)
        {
            this.type = type;
        }

        /// <summary>
        /// Returns an index that represents the dynamic
        /// 0 = INVALID
        /// 1 = ppp
        /// 2 = pp
        /// etc
        /// </summary>
        /// <returns>Returns the index of this dynamic</returns>
        public int getIndex()
        {
            return type;
        }

        /// <summary>
        /// Returns the GPDynamic associated with the value of the argument 'type'
        /// </summary>
        /// <param name="type">The dynamic index to look up</param>
        /// <returns>The Dynamic that 'type' represents</returns>
        public static GPDynamic valueOf(int type)
        {
            return dynamics[type];
        }

        /// <summary>
        /// Returns the string representation of this class
        /// </summary>
        /// <returns>The string representation of this class</returns>
        public string toString()
        {
            return dynamicsName[type];
        }
    }
}
