﻿using System;
using System.Drawing;
using System.Windows.Forms;
using GuitarTrainer.GuitarProComponents;

namespace GuitarTrainer.GUI
{
    /// <summary>
    /// Class that defines where the music cursor is located
    /// </summary>
    class MusicCursorPosition
    {
        private int measureNum;
        private int beatNum;
        private Control control;

        // Either a beat or a bar
        private object song;

        private bool isBeat;

        /// <summary>
        /// Default constructor
        /// </summary>
        public MusicCursorPosition()
        {
            beatNum = 1;
            measureNum = 1;
            Point = new Point();
            song = null;
            Width = 10;
        }

        /// <summary>
        /// How to print out this class for debugging mostly
        /// </summary>
        /// <returns>The string this class represents</returns>
        public override string ToString()
        {
            string toReturn = "Music Cursor Position ";

            toReturn += "Measure: " + measureNum;
            toReturn += ", Beat: " + beatNum;
            toReturn += ", point: " + Point;

            if (song != null)
            {
                if (isBeat)
                    toReturn += ", isBeat";
                else
                    toReturn += ", isBar";
            }

            return toReturn;
        }

        #region Getters and setters

        public int BeatNum
        {
            set 
            { 
                if(value >= 1)
                    beatNum = value; 
            }
        }

        public Point Point { get; set; }

        public int Width { get; set; }

        /// <summary>
        /// Sets the song to the bar or the beat you want the cursor to be associated with
        /// </summary>
        /// <param name="o">The object to set</param>
        public void setSong(object o)
        {
            Type t;

            if (o != null)
            {
                t = o.GetType();
                if (t.IsInstanceOfType(new GPBeat()))
                    isBeat = true;
                else if (t.IsInstanceOfType(new GPMeasureTrackPair()))
                    isBeat = false;
                else
                {
                    MessageBox.Show("Object m ust be either a GPBeat or Bar");
                    Environment.Exit(0);
                }
                song = o;

                // added myself
            }
            else
            {
                MessageBox.Show("Object must not be null");
                Environment.Exit(0);
            }
        }
        public Control Control
        {
            get { return control; }
            set { control = value; }
        }
        #endregion

    }
}
