/*
 * Decompiled with CFR 0.152.
 */
package jCarcassonne;

import jCarcassonne.Tile;
import jCarcassonne.TileFeature;
import jCarcassonne.TileFeatureFactory;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.Stack;
import javax.imageio.ImageIO;

public class TileStack
extends Stack<Tile> {
    private static final long serialVersionUID = 1L;
    private String tilesetFolder = "./tileset/";
    private String imageFileExtension = ".gif";
    private int tileWidth = 128;
    private int tileHeight = 128;
    private boolean ignoreCount = false;

    protected void loadTileSet(String tilesetFilename) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(String.valueOf(this.tilesetFolder) + tilesetFilename));
            int tilesRead = 1;
            while (in.ready()) {
                ArrayList<String[]> tileDescription = new ArrayList<String[]>();
                String line = in.readLine();
                while (line.startsWith("#") || line.isEmpty()) {
                    line = in.readLine();
                }
                while (!line.isEmpty()) {
                    if (!line.startsWith("#")) {
                        tileDescription.add(line.split(" "));
                    }
                    line = in.readLine();
                }
                int tileCount = 1;
                if (!this.ignoreCount) {
                    tileCount = Integer.parseInt(((String[])tileDescription.get(1))[1]);
                }
                int i = 0;
                while (i < tileCount) {
                    Tile t = this.createTile(tileDescription);
                    if (t == null) {
                        System.out.println("Tileset error: tile " + tilesRead);
                    } else {
                        this.push(t);
                    }
                    ++i;
                }
                ++tilesRead;
            }
        }
        catch (IOException e) {
            System.out.println("Error reading " + tilesetFilename + ".");
            System.out.println(e);
            System.exit(0);
        }
    }

    private Tile createTile(ArrayList<String[]> tileDescription) {
        String tileName = tileDescription.get(0)[0];
        String imageFilename = String.valueOf(this.tilesetFolder) + tileName + this.imageFileExtension;
        String imageFeatureMapFilename = String.valueOf(this.tilesetFolder) + tileName + "FeatureMap" + this.imageFileExtension;
        BufferedImage img = null;
        BufferedImage imgFeatureMap = null;
        try {
            img = ImageIO.read(new File(imageFilename));
            File temp = new File(imageFeatureMapFilename);
            imgFeatureMap = temp.canRead() ? ImageIO.read(temp) : ImageIO.read(new File(imageFilename));
        }
        catch (IOException e) {
            System.out.println();
            System.out.println(e);
            System.exit(0);
        }
        if (img.getWidth() != this.tileWidth || img.getHeight() != this.tileHeight) {
            return null;
        }
        Tile t = new Tile(img, imgFeatureMap, tileName);
        this.createTileFeatures(tileDescription, t);
        String err = t.verifyFeatures();
        if (err != null) {
            System.out.println(err);
        }
        return t;
    }

    private void createTileFeatures(ArrayList<String[]> tileDescription, Tile tile) throws NumberFormatException {
        TileFeatureFactory featureFactory = new TileFeatureFactory();
        int j = 2;
        while (j < tileDescription.size()) {
            String[] flags;
            String[] featureString = tileDescription.get(j);
            TileFeature.FeatureEnum featureType = TileFeature.FeatureEnum.valueOf(featureString[0]);
            int tokenX = Integer.parseInt(featureString[1]);
            int tokenY = Integer.parseInt(featureString[2]);
            String borderString = featureString[3];
            boolean[] borderArray = new boolean[13];
            int maxNeighbors = 0;
            int b = 0;
            while (b < borderArray.length) {
                if (borderString.charAt(b) == '1') {
                    borderArray[b] = true;
                    ++maxNeighbors;
                } else {
                    borderArray[b] = false;
                }
                ++b;
            }
            int colorCode = Integer.decode(featureString[4]);
            if (featureString.length > 5) {
                flags = new String[featureString.length - 5];
                System.arraycopy(featureString, 5, flags, 0, featureString.length - 5);
            } else {
                flags = null;
            }
            TileFeature feature = featureFactory.newTileFeature(featureType, maxNeighbors, tokenX, tokenY, tile, colorCode, flags);
            int k = 0;
            while (k < borderArray.length) {
                if (borderArray[k]) {
                    tile.addFeature(feature, k);
                }
                ++k;
            }
            ++j;
        }
    }

    protected void shuffleStack() {
        Stack<Tile> tempStack = new Stack<Tile>();
        Tile startTile = null;
        while (!this.isEmpty()) {
            Random rand = new Random();
            int r = rand.nextInt(this.size());
            Tile t = (Tile)this.get(r);
            this.remove(r);
            if (t.name.equals("startTile") && startTile == null) {
                startTile = t;
                continue;
            }
            tempStack.push(t);
        }
        if (this.isEmpty()) {
            this.addAll(tempStack);
            this.push(startTile);
        }
    }

    protected int getTileWidth() {
        return this.tileWidth;
    }

    protected int getTileHeight() {
        return this.tileHeight;
    }

    protected void setIgnoreCount(boolean ignoreCount) {
        this.ignoreCount = ignoreCount;
    }
}

