/*
 * Decompiled with CFR 0.152.
 */
package jCarcassonne;

import jCarcassonne.City;
import jCarcassonne.Cloister;
import jCarcassonne.Farm;
import jCarcassonne.Road;
import jCarcassonne.Tile;
import jCarcassonne.TileFeature;

public class TileFeatureFactory {
    protected TileFeature newTileFeature(TileFeature.FeatureEnum featureType, int maxNeighbors, int tokenX, int tokenY, Tile tile, int colorCode, String[] flag) {
        TileFeature feature = null;
        if (featureType == TileFeature.FeatureEnum.road) {
            Road roadFeature;
            feature = roadFeature = new Road(maxNeighbors, tokenX, tokenY, tile, colorCode);
        } else if (featureType == TileFeature.FeatureEnum.cloister) {
            feature = new Cloister(maxNeighbors, tokenX, tokenY, tile, colorCode);
        } else if (featureType == TileFeature.FeatureEnum.city) {
            boolean pennant = false;
            if (flag != null && flag[0].equals("pennant")) {
                pennant = true;
            }
            City cityFeature = new City(maxNeighbors, tokenX, tokenY, tile, pennant, colorCode);
            feature = cityFeature;
        } else if (featureType == TileFeature.FeatureEnum.farm) {
            int[] cityColorCodes = new int[]{};
            if (flag != null) {
                cityColorCodes = new int[flag.length];
                int i = 0;
                while (i < flag.length) {
                    cityColorCodes[i] = Integer.decode(flag[i]);
                    ++i;
                }
            }
            Farm farmFeature = new Farm(maxNeighbors, tokenX, tokenY, tile, colorCode, cityColorCodes);
            feature = farmFeature;
        }
        return feature;
    }
}

