/*
 * Decompiled with CFR 0.152.
 */
package jCarcassonne;

import jCarcassonne.Tile;
import jCarcassonne.Token;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public abstract class TileFeature {
    protected final FeatureEnum featureType;
    private int tokenX;
    private int tokenY;
    protected final Tile tile;
    protected final int indexColorCode;
    private Token token = null;
    private boolean scored = false;
    protected boolean isComplete = false;
    private ArrayList<TileFeature> neighbors;
    private int numNeighbors = 0;
    private final int maxNeighbors;

    protected TileFeature(FeatureEnum f, int maxNeighbors, int tokenX, int tokenY, Tile tile, int indexColorCode) {
        this.featureType = f;
        this.maxNeighbors = maxNeighbors;
        this.tokenX = tokenX;
        this.tokenY = tokenY;
        this.tile = tile;
        this.indexColorCode = indexColorCode;
        this.neighbors = new ArrayList();
    }

    protected void addNeighbor(TileFeature tf) {
        this.neighbors.add(tf);
        ++this.numNeighbors;
    }

    protected Iterator<TileFeature> getNeighborIterator() {
        return this.neighbors.iterator();
    }

    protected int getNumNeighbors() {
        return this.numNeighbors;
    }

    protected int getMaxNeighbors() {
        return this.maxNeighbors;
    }

    protected void placeToken(Token token) {
        this.token = token;
        token.setPlaced(true);
    }

    protected void removeToken() {
        this.token.setPlaced(false);
        this.token = null;
    }

    protected Token getToken() {
        return this.token;
    }

    protected boolean hasToken() {
        return this.token != null;
    }

    public String toString() {
        return this.featureType.toString();
    }

    protected void setScored(boolean scored) {
        this.scored = scored;
    }

    protected boolean isScored() {
        return this.scored;
    }

    protected Point getTokenCoordinates() {
        return new Point(this.tokenX, this.tokenY);
    }

    protected void setTokenCoordinates(int x, int y) {
        this.tokenX = x;
        this.tokenY = y;
    }

    protected Tile getTile() {
        return this.tile;
    }

    protected int getColorCode() {
        return this.indexColorCode;
    }

    protected abstract boolean isComplete();

    protected HashSet<Tile> getTilesInFeatureGroup() {
        HashSet<TileFeature> featuresInGroup = this.getFeaturesInGroup();
        HashSet<Tile> tilesInGroup = new HashSet<Tile>();
        for (TileFeature feature : featuresInGroup) {
            tilesInGroup.add(feature.getTile());
        }
        return tilesInGroup;
    }

    protected HashSet<Token> getTokensOnFeatureGroup() {
        HashSet<TileFeature> featuresInGroup = this.getFeaturesInGroup();
        HashSet<Token> tokensInGroup = new HashSet<Token>();
        for (TileFeature feature : featuresInGroup) {
            if (!feature.hasToken()) continue;
            tokensInGroup.add(feature.getToken());
        }
        return tokensInGroup;
    }

    protected HashSet<TileFeature> getFeaturesInGroup() {
        return this.getFeaturesInGroup(this, new HashSet<TileFeature>());
    }

    private HashSet<TileFeature> getFeaturesInGroup(TileFeature feature, HashSet<TileFeature> featuresFound) {
        Iterator<TileFeature> neighborIterator = feature.getNeighborIterator();
        while (neighborIterator.hasNext()) {
            TileFeature neighbor = neighborIterator.next();
            if (featuresFound.contains(neighbor)) continue;
            featuresFound.add(neighbor);
            this.getFeaturesInGroup(neighbor, featuresFound);
        }
        return featuresFound;
    }

    public void setComplete(boolean isComplete) {
        this.isComplete = isComplete;
    }

    protected static enum FeatureEnum {
        city,
        road,
        farm,
        cloister,
        river,
        empty;

    }
}

