/*
 * Decompiled with CFR 0.152.
 */
package jCarcassonne;

import jCarcassonne.City;
import jCarcassonne.Landscape;
import jCarcassonne.Player;
import jCarcassonne.Tile;
import jCarcassonne.TileFeature;
import jCarcassonne.Token;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Rules {
    private boolean verbose = false;
    private Landscape landscape;

    protected Rules(Landscape landscape) {
        this.landscape = landscape;
    }

    protected void setVerbose(boolean v) {
        this.verbose = v;
    }

    protected boolean checkTilePlacement(Landscape l, Tile t, int x, int y) {
        if (l.hasTileAt(x, y) || t == null) {
            return false;
        }
        Tile n = l.getTile(x, y + 1);
        Tile s = l.getTile(x, y - 1);
        Tile e = l.getTile(x + 1, y);
        Tile w = l.getTile(x - 1, y);
        if (n == null && s == null && e == null && w == null) {
            return false;
        }
        if (n != null && t.getFeatureAtBorder((int)1).featureType != n.getFeatureAtBorder((int)7).featureType) {
            if (this.verbose) {
                System.out.println("North border: " + (Object)((Object)t.getFeatureAtBorder((int)1).featureType) + " != " + (Object)((Object)n.getFeatureAtBorder((int)7).featureType));
            }
            return false;
        }
        if (s != null && t.getFeatureAtBorder((int)7).featureType != s.getFeatureAtBorder((int)1).featureType) {
            if (this.verbose) {
                System.out.println("South border: " + (Object)((Object)t.getFeatureAtBorder((int)7).featureType) + " != " + (Object)((Object)s.getFeatureAtBorder((int)1).featureType));
            }
            return false;
        }
        if (e != null && t.getFeatureAtBorder((int)4).featureType != e.getFeatureAtBorder((int)10).featureType) {
            if (this.verbose) {
                System.out.println("East border: " + (Object)((Object)t.getFeatureAtBorder((int)4).featureType) + " != " + (Object)((Object)e.getFeatureAtBorder((int)10).featureType));
            }
            return false;
        }
        if (w != null && t.getFeatureAtBorder((int)10).featureType != w.getFeatureAtBorder((int)4).featureType) {
            if (this.verbose) {
                System.out.println("West border: " + (Object)((Object)t.getFeatureAtBorder((int)10).featureType) + " != " + (Object)((Object)w.getFeatureAtBorder((int)4).featureType));
            }
            return false;
        }
        return true;
    }

    protected boolean checkTokenPlacement(Landscape landscape, Tile tileClicked, TileFeature featureClicked, Player player) {
        boolean isOKPlacement = false;
        String verboseOutput = "";
        if (landscape != null && tileClicked != null && featureClicked != null && player != null) {
            if (tileClicked == landscape.getLastTilePlaced()) {
                if (this.isUncontestedFeature(featureClicked, player)) {
                    verboseOutput = "CheckTokenPlacement: token OK";
                    isOKPlacement = true;
                } else {
                    verboseOutput = "CheckTokenPlacement: feature is contested";
                }
            } else {
                verboseOutput = "CheckTokenPlacement: not last tile";
            }
        } else {
            verboseOutput = "CheckTokenPlacement: bad input";
        }
        if (this.verbose) {
            System.out.println(verboseOutput);
        }
        return isOKPlacement;
    }

    protected void scoreTile(Tile tile) {
        if (tile != null) {
            Iterator<TileFeature> featureIterator = tile.getFeatureIterator();
            while (featureIterator.hasNext()) {
                TileFeature feature = featureIterator.next();
                if (feature.isScored() || !feature.isComplete()) continue;
                HashSet<Token> tokensOnFeature = feature.getTokensOnFeatureGroup();
                HashSet<Player> featureOwners = this.getFeatureOwners(tokensOnFeature);
                int featureScore = this.scoreFeature(feature, true);
                for (Player player : featureOwners) {
                    player.setScore(player.getScore() + featureScore);
                    if (!this.verbose) continue;
                    System.out.println("ScoreTile: " + player.getName() + " score=" + player.getScore());
                }
                for (Token token : tokensOnFeature) {
                    token.getFeature().removeToken();
                }
            }
        }
    }

    private int scoreFeature(TileFeature feature, boolean isComplete) {
        HashSet<Tile> tilesInFeature = feature.getTilesInFeatureGroup();
        if (feature.featureType == TileFeature.FeatureEnum.road) {
            return tilesInFeature.size();
        }
        if (feature.featureType == TileFeature.FeatureEnum.city) {
            int score = tilesInFeature.size() + ((City)feature).getNumPennants();
            if (isComplete && tilesInFeature.size() > 2) {
                score *= 2;
            }
            return score;
        }
        if (feature.featureType == TileFeature.FeatureEnum.cloister) {
            return this.landscape.getNumSurroundingTiles(feature.getTile()) + 1;
        }
        return 0;
    }

    private boolean isUncontestedFeature(TileFeature featureClicked, Player player) {
        HashSet<Token> tokensOnFeature = featureClicked.getTokensOnFeatureGroup();
        for (Token token : tokensOnFeature) {
            if (token.getPlayer() == player) continue;
            return false;
        }
        return true;
    }

    private HashSet<Player> getFeatureOwners(HashSet<Token> tokensOnFeature) {
        HashMap<Player, Integer> tokensPerPlayer = new HashMap<Player, Integer>();
        int maxTokenCount = 0;
        for (Token token : tokensOnFeature) {
            Player player = token.getPlayer();
            if (tokensPerPlayer.containsKey(player)) {
                Integer tokenCount = (Integer)tokensPerPlayer.get(player);
                tokenCount = new Integer(tokenCount + 1);
                tokensPerPlayer.put(player, tokenCount);
            } else {
                tokensPerPlayer.put(player, new Integer(1));
            }
            if ((Integer)tokensPerPlayer.get(player) <= maxTokenCount) continue;
            maxTokenCount = (Integer)tokensPerPlayer.get(player);
        }
        HashSet<Player> featureOwners = new HashSet<Player>();
        for (Player player : tokensPerPlayer.keySet()) {
            if ((Integer)tokensPerPlayer.get(player) != maxTokenCount) continue;
            featureOwners.add(player);
        }
        return featureOwners;
    }

    protected void scoreAllTokens(Iterator<Player> playersIterator) {
        HashSet<Token> tokensOnFarms = new HashSet<Token>();
        while (playersIterator.hasNext()) {
            Player player = playersIterator.next();
            Iterator<Token> tokenIterator = player.getTokenIterator();
            while (tokenIterator.hasNext()) {
                Token token = tokenIterator.next();
                if (!token.isPlaced()) continue;
                if (token.getFeature().featureType == TileFeature.FeatureEnum.farm) {
                    tokensOnFarms.add(token);
                    continue;
                }
                int featureScore = this.scoreFeature(token.getFeature(), false);
                player.setScore(player.getScore() + featureScore);
                token.getFeature().removeToken();
            }
        }
    }
}

