/*
 * Decompiled with CFR 0.152.
 */
package jCarcassonne;

import jCarcassonne.Tile;
import java.awt.Point;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class Landscape {
    private ConcurrentHashMap<Point, Tile> landscapeHash = new ConcurrentHashMap();
    private int lastX = 0;
    private int lastY = 0;
    private Tile lastTilePlaced;

    protected Landscape(Tile startTile) {
        this.landscapeHash.put(new Point(0, 0), startTile);
        startTile.setXY(0, 0);
    }

    protected void placeTile(Tile tile, int x, int y) {
        this.landscapeHash.put(new Point(x, y), tile);
        tile.setXY(x, y);
        this.lastX = x;
        this.lastY = y;
        this.lastTilePlaced = tile;
        tile.setPlaced(true);
        Point p = new Point(x, y);
        p.translate(0, 1);
        if (this.landscapeHash.containsKey(p)) {
            tile.setNorthTile(this.landscapeHash.get(p));
            this.landscapeHash.get(p).setSouthTile(tile);
        }
        p.translate(0, -2);
        if (this.landscapeHash.containsKey(p)) {
            tile.setSouthTile(this.landscapeHash.get(p));
            this.landscapeHash.get(p).setNorthTile(tile);
        }
        p.translate(1, 1);
        if (this.landscapeHash.containsKey(p)) {
            tile.setEastTile(this.landscapeHash.get(p));
            this.landscapeHash.get(p).setWestTile(tile);
        }
        p.translate(-2, 0);
        if (this.landscapeHash.containsKey(p)) {
            tile.setWestTile(this.landscapeHash.get(p));
            this.landscapeHash.get(p).setEastTile(tile);
        }
    }

    protected Tile getTile(int x, int y) {
        return this.landscapeHash.get(new Point(x, y));
    }

    protected boolean hasTileAt(int x, int y) {
        return this.landscapeHash.containsKey(new Point(x, y));
    }

    protected Tile getLastTilePlaced() {
        return this.lastTilePlaced;
    }

    protected int getLastX() {
        return this.lastX;
    }

    protected int getLastY() {
        return this.lastY;
    }

    protected Iterator<Tile> getLandscapeIterator() {
        return this.landscapeHash.values().iterator();
    }

    protected int getNumSurroundingTiles(Tile tile) {
        Point p = tile.getPoint();
        int x = p.x;
        int y = p.y;
        int numSurroundingTiles = 0;
        if (this.hasTileAt(x, y - 1)) {
            ++numSurroundingTiles;
        }
        if (this.hasTileAt(x + 1, y - 1)) {
            ++numSurroundingTiles;
        }
        if (this.hasTileAt(x + 1, y)) {
            ++numSurroundingTiles;
        }
        if (this.hasTileAt(x + 1, y + 1)) {
            ++numSurroundingTiles;
        }
        if (this.hasTileAt(x, y + 1)) {
            ++numSurroundingTiles;
        }
        if (this.hasTileAt(x - 1, y + 1)) {
            ++numSurroundingTiles;
        }
        if (this.hasTileAt(x - 1, y)) {
            ++numSurroundingTiles;
        }
        if (this.hasTileAt(x - 1, y - 1)) {
            ++numSurroundingTiles;
        }
        return numSurroundingTiles;
    }
}

