/*
 * Decompiled with CFR 0.152.
 */
package jCarcassonne;

import jCarcassonne.Landscape;
import jCarcassonne.Player;
import jCarcassonne.Rules;
import jCarcassonne.Tile;
import jCarcassonne.TileFeature;
import jCarcassonne.TileStack;
import jCarcassonne.Token;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;

public class GameController {
    private Rules rules;
    private TileStack tileStack;
    private Landscape landscape;
    private ArrayList<Player> players;
    private Iterator<Player> playersIterator;
    private Player currentPlayer;
    private boolean tilePlacedThisTurn = false;
    private boolean gameStarting = true;
    private boolean gameOver = false;

    public GameController() {
        this.newGame();
    }

    public void newGame() {
        this.tileStack = new TileStack();
        this.tileStack.setIgnoreCount(false);
        this.tileStack.loadTileSet("tileset.txt");
        this.tileStack.shuffleStack();
        this.landscape = new Landscape((Tile)this.tileStack.pop());
        this.rules = new Rules(this.landscape);
        this.rules.setVerbose(false);
        this.players = new ArrayList();
        this.tilePlacedThisTurn = false;
        this.gameStarting = true;
        this.gameOver = false;
    }

    public void addPlayer(String playerName, Color playerColor) {
        if (this.gameStarting && !this.gameOver) {
            this.players.add(new Player(playerName, playerColor));
        }
    }

    public void endTurn() {
        if (!this.gameOver && !this.gameStarting && this.tilePlacedThisTurn) {
            this.rules.scoreTile(this.landscape.getLastTilePlaced());
            this.tilePlacedThisTurn = false;
            if (this.playersIterator.hasNext()) {
                this.currentPlayer = this.playersIterator.next();
            } else {
                this.playersIterator = this.players.iterator();
                this.currentPlayer = this.playersIterator.next();
            }
        }
    }

    public void startGame() {
        if (this.players.size() > 1) {
            this.gameStarting = false;
            this.gameOver = false;
            this.playersIterator = this.players.iterator();
            this.currentPlayer = this.playersIterator.next();
        }
    }

    public void endGame() {
        if (!this.gameStarting && !this.gameOver) {
            this.gameOver = true;
            this.rules.scoreTile(this.landscape.getLastTilePlaced());
            this.tilePlacedThisTurn = false;
            this.rules.scoreAllTokens(this.players.iterator());
        }
    }

    public void rotateNextTile() {
        if (!(this.gameOver || this.gameStarting || this.tilePlacedThisTurn || this.tileStack.empty())) {
            ((Tile)this.tileStack.peek()).rotate();
        }
    }

    private void placeTile(int xInModel, int yInModel) {
        if (!(this.gameOver || this.gameStarting || this.tilePlacedThisTurn || this.tileStack.empty() || !this.rules.checkTilePlacement(this.landscape, (Tile)this.tileStack.peek(), xInModel, yInModel))) {
            this.landscape.placeTile((Tile)this.tileStack.pop(), xInModel, yInModel);
            this.tilePlacedThisTurn = true;
        }
    }

    private void placeToken(int xInModel, int yInModel, int xInTile, int yInTile) {
        TileFeature featureClicked;
        Tile tileClicked;
        if (!this.gameOver && !this.gameStarting && this.tilePlacedThisTurn && (tileClicked = this.landscape.getTile(xInModel, yInModel)) != null && this.rules.checkTokenPlacement(this.landscape, tileClicked, featureClicked = tileClicked.getFeatureAt(xInTile, yInTile), this.currentPlayer)) {
            if (tileClicked.hasToken()) {
                tileClicked.getToken().getFeature().removeToken();
            }
            if (this.currentPlayer.hasToken()) {
                Token token = this.currentPlayer.getToken();
                tileClicked.placeToken(token, xInTile, yInTile);
            }
        }
    }

    public void handleLandscapeClick(int xInModel, int yInModel, int xInTile, int yInTile) {
        if (!this.tilePlacedThisTurn) {
            this.placeTile(xInModel, yInModel);
        } else {
            this.placeToken(xInModel, yInModel, xInTile, yInTile);
        }
    }

    public BufferedImage getNextTileImage() {
        if (!this.tileStack.empty()) {
            return ((Tile)this.tileStack.peek()).getImage();
        }
        return null;
    }

    public String getCurrentPlayerName() {
        if (this.currentPlayer != null) {
            return this.currentPlayer.getName();
        }
        return null;
    }

    public int getCurrentPlayerTokenCount() {
        if (this.currentPlayer != null) {
            return this.currentPlayer.getTokenCount();
        }
        return 0;
    }

    public Color getCurrentPlayerColor() {
        if (this.currentPlayer != null) {
            return this.currentPlayer.getColor();
        }
        return null;
    }

    public Iterator<Tile> getLandscapeIterator() {
        return this.landscape.getLandscapeIterator();
    }

    public Iterator<Player> getPlayersIterator() {
        return this.players.iterator();
    }

    public boolean isGameOver() {
        return this.gameOver;
    }

    public boolean isGameStarting() {
        return this.gameStarting;
    }
}

