/* Main.cpp
 * Created on: Feb 16, 2009
 * Author: Ian Roskam
 */
#include <nds.h>

#include "Title.h"
#include "CharacterSelect.h"
#include "FightEngine.h"
#include "Help.h"
#include "About.h"
#include "gameState.h" //global game states

void initVideo()
{
	powerOn(POWER_ALL_2D);  //turn on both 2D cores
    vramSetMainBanks(VRAM_A_MAIN_BG_0x06000000, //all backgrounds go here
                     VRAM_B_MAIN_SPRITE_0x06400000, //all sprites go here
                     VRAM_C_LCD, // not used
                     VRAM_D_LCD);  // not used

    //Mode 5 supports 2 text background and 2 exrot backgrounds.
	videoSetMode(MODE_5_2D | DISPLAY_SPR_ACTIVE | DISPLAY_BG2_ACTIVE);

	irqInit(); //Initilize default interrupt handler
	irqEnable(IRQ_VBLANK | IRQ_KEYS); //Enable vBlank interrupt
	oamEnable(&oamMain); //turn on sprite rendering
}

//A pointer to each looping class
Title * title = NULL;
CharacterSelect * csSelect = NULL;
FightEngine * fightEngine = NULL;
Help* help = NULL;
About* about = NULL;
//end pointers

/**
 * This is a master callback method for all class vBlank handlers.
 */
void VBlank()
{
	if(title!=NULL)
	{
		title->vBlank();
	}
	if(csSelect!=NULL)
	{
		csSelect->vBlank();
	}
	if(fightEngine!=NULL)
	{
		fightEngine->vBlank();
	}
}

//gameStates used for switch control
gameState current = TITLE;
gameState next = CS;
//end gameStates

/**
 * Enumerations used to get values from CharacterSelect that will be passed to
 * FightEngine.
 */
Character::characters playerOne = Character::AKUMA;
Character::characters playerTwo = Character::AKUMA;
Background::bgImage fightBg = Background::AIRFORCE;

/**
 * This is the controller for switching between states.  When a state is
 * selected a new object in created and the classe's start method is called.
 * When a class is done looping it returns the next state and is deleted.
 */
void control()
{
	switch(current)
	{
		case TITLE:
			iprintf("\nclass is title");
			title = new Title();
			next = title->start();
			delete title;
			title = NULL;
			current = next;
			break;
		case CS:
			iprintf("\nclass is CharacterSelect");
			csSelect = new CharacterSelect();
			next = csSelect->start();
			if(next==FIGHT)
			{
				playerOne = csSelect->getP1();
				playerTwo = csSelect->getP2();
				fightBg = csSelect->getFightBg();
			}
			delete csSelect;
			csSelect = NULL;
			current = next;
			break;
		case FIGHT:
			iprintf("\nclass is fightEngine");
			fightEngine = new FightEngine(playerOne, playerTwo, fightBg);
			next = fightEngine->start();
			delete fightEngine;
			fightEngine = NULL;
			current = next;
			break;
		case HELP:
			iprintf("\nclass is help");
			help = new Help();
			next = help->start();
			delete help;
			help = NULL;
			current = next;
			break;
		case ABOUT:
			iprintf("\nclass is about");
			about = new About();
			next = about->start();
			delete about;
			about = NULL;
			current = next;
			break;
		default:
			return;
	}
}
/**
 * X and Y keys cannot be read directly by the ARM9.  Interrupts are used to get
 * the current states of both X and Y keys.  This handler is called when a key
 * interrupt happens.
 */
void KeysInterrupt()
{
	iprintf("\nx or y pressed");
}
/**
 * The main game loop.
 */
int main(void){
	initVideo();
	consoleDemoInit();
	iprintf("\n\n\tChampion Demo\n");
	iprintf("\tIan Roskam\n");
	irqSet(IRQ_VBLANK, &VBlank);
	//irqSet(IRQ_KEYS, &KeysInterrupt);

	while(1) //the main game loop
	{
		control();
	}
	return 0;
}
