/* Title.h
 * Created on: Mar 6, 2009
 * Author: Ian
 */

/**
 * The title screen is loaded when Champion starts.
 */

#ifndef TITLE_H_
#define TITLE_H_

#include "Background.h"
#include "CharacterSelect.h"
#include "Cursor.h"
#include "gameState.h"

/**
 * This is the title screen for Champion.
 */
class Title
{
public:
	Title(); //Constructor
	void vBlank(); //actions to do during a VBlank
	gameState start(); //begin the title loop
	~Title(); //Destructor
private:
	bool done;
	gameState nextState;
	enum menuItem{
		fight, help, about
	};
	Background* background;
	Cursor* cursor;
	menuItem selected;
	uint32 keys;
	void down();
	void up();
	void select();
	void updateCursor();
	void handleInput(); //check what keys are being pressed
};
#endif /* TITLE_H_ */
