/* Sprite.h
 * Created on: Apr 1, 2009
 * Author: Ian
 */

/**
 * This class handles all of the memory shuffling that is required for sprites.
 * The Character class contains a member of the Sprite class.
 */

#ifndef SPRITE_H_
#define SPRITE_H_

class Sprite {
public:
	//enumeration of all possible animation strips
	enum strips{
		STANCE, FOWARD, REVERSE, JUMP, DUCK, BLOCK, LOWPUNCH, HIGHPUNCH,
		LOWKICK, HIGHKICK
	};
	Sprite();
	void init(const short unsigned int* spriteSheet,
		unsigned int spriteSheetSize, const short unsigned int* spritePalette,
		unsigned int spritePaletteSize,int oamID, int posX, int posY,
		int direction);
	const static int LEFT = -1;  //character is facing left
	const static int RIGHT = 1;  //character is facing right
	void initSprites();
	void nextFrame();
	void loadStrip(strips animationStrip);  //load current strip into VRAM
	void animateSprite();

	//begin inline functions
	void updateOAM(){oamUpdate(&oamMain);}
	void setAnimFrame(int animFrame){this->animFrame = animFrame;}
	void setPosX(int posX){this->posX = posX;}
	int getPosX(){return posX;}
	void incrPosX(){posX++;}
	void decrPosX(){posX--;}
	void forward(){posX += direction;}
	void reverse(){posX -= direction;}
	void setPosY(int posY){this->posY = posY;}
	int getPosY(){return posY;}
	void incrPosY(){posY++;}
	void decrPosY(){posY--;}
	void setDirection(int direction){this->direction = direction;}
	int getDirection(){return direction;}
	bool animIsDone(){return animDone;}
	//end inline functions

	~Sprite(); //Destructor
private:
	int SPRITE_SIZE; //height and width of a frame
	int MAX_FRAMES;
	int divider;
	u16* spriteGfxMem[10];  //pointer to VRAM destination
	const short unsigned int* spriteSheet; //pointer to graphics source
	unsigned int spriteSheetSize; //size of sprite sheet height*width
	const short unsigned int* spritePalette; //pointer to palette source
	unsigned int spritePaletteSize; //size of sprite palette
	int oamID;
	int frameStrip; //the current animation strip
	int animFrame;  //the current displayed animation frame
	int framesPerAnimation;
	int cycleFrames;
	int posX, posY, direction;
	bool vflip;
	bool loop, animDone;

	void setFramesPerAnimation(strips animationStrip);

	unsigned int spriteMemoryUsage;// = 0;
	unsigned int oomCount;// = 0;
	unsigned int allocationCount;// = 0;
	unsigned int spriteMemSize;// = 128 * 1024;
};
#endif /* SPRITE_H_ */
