/* Help.cpp
 * Created on: Apr 20, 2009
 * Author: Ian Roskam
 */
#include <nds.h>

#include "Help.h"

/**
 * Create a new background using the 'help' background.
 */
Help::Help()
{
	this->background = new Background(Background::HELP);
	this->done = false;
}
/**
 * Check if any keys are being pressed.  Only the 'B' button is used here.
 */
void Help::handleInput()
{
	scanKeys();
	if(keysDown()&KEY_B)
		done = true;
}
/**
 * Start the loop that checks for input.
 * @return - will always return TITLE as the next game state
 */
gameState Help::start()
{
	background->display();
	while(!done)
	{
		handleInput();
	}
	return TITLE;
}
/**
 * Free up the memory used by the background.
 */
Help::~Help()
{
	if(background!=NULL)
	{
		delete background;
		background = NULL;
	}
}
