/* FightEngine.cpp
 * Created on: Mar 9, 2009
 * Author: Ian Roskam
 */

#include <nds.h>

#include "../gfx/lose.h"
#include "../gfx/youWin.h"

#include "FightEngine.h"

/**
 * The FightEngine constructor is called by the CharacterSelect class after
 * both characters and a map are selected.
 *
 * @param p1 a pointer to the character object used by player one
 * @param p2 a pointer to the character object used by player two
 * @param backgroundSrc a pointer to the background
 */
FightEngine::FightEngine(Character::characters playerOne,
						 Character::characters playerTwo,
						 Background::bgImage fightBg) //Constructor
{
	this->playerOne = new Character(playerOne, true);
	this->playerTwo = new Character(playerTwo, false);
	this->background = new Background(fightBg);
	this->healthDisplay = NULL;
	//healthDisplay->drawToken(true,1);
	this->nextState = CS;
	this->done = this->paused = false;
	this->p1Wins = this->p2Wins = 1;
	this->maxWins = 3;
}

/**
 * Display draws playerOne and playerTwo sprites.  This method is called on
 * each iteration of the game loop.
 */
void FightEngine::display()
{
	playerOne->display();
	playerTwo->display();
}
void FightEngine::togglePause()
{
	if(paused==false)
	{
		iprintf("\npaused");
		paused = true;
	}
	else
	{
		iprintf("\nunpaused");
		paused = false;
	}
}
/**
 * Checks what buttons are being pressed.
 */
void FightEngine::handleInput()
{
	scanKeys();
	keys = keysDown();
	if(keys==KEY_START) //pause game and display pause menu
		togglePause();
	if(keys==KEY_SELECT) // not currently used
		p2Wins = 3;
}
/**
 * Colision detection check if pixels from character 1's offensive mask
 * collide with pixels from character 2's defensive mask.
 */
/*
bool FightEngine::detectCollision(sprite* object1, sprite* object2) {
	// Full object-to-object pixel-level collision detector:

	int left1, left2, over_left;
	int right1, right2, over_right;
	int top1, top2, over_top;
	int bottom1, bottom2, over_bottom;
	int over_width, over_height;
	int i, j;
	unsigned char *pixel1, *pixel2;

	left1 = object1->x;
	left2 = object2->x;
	right1 = object1->x + object1->width;
	right2 = object2->x + object2->width;
	top1 = object1->y;
	top2 = object2->y;
	bottom1 = object1->y + object1->height;
	bottom2 = object2->y + object2->height;

	// Trivial rejections:
	if (bottom1 < top2)
		return (0);
	if (top1 > bottom2)
		return (0);

	if (right1 < left2)
		return (0);
	if (left1 > right2)
		return (0);

	// Ok, compute the rectangle of overlap:
	if (bottom1 > bottom2)
		over_bottom = bottom2;
	else
		over_bottom = bottom1;

	if (top1 < top2)
		over_top = top2;
	else
		over_top = top1;

	if (right1 > right2)
		over_right = right2;
	else
		over_right = right1;

	if (left1 < left2)
		over_left = left2;
	else
		over_left = left1;

	// Now compute starting offsets into both objects' bitmaps:
	i = ((over_top - object1\1->y) * object1->width) + over_left;
	pixel1 = object1->frames[object1->curr_frame] + i;

	j = ((over_top - object2->y) * object2->width) + over_left;
	pixel2 = object2->frames[object2->curr_frame] + j;

	// Now start scanning the whole rectangle of overlap,
	// checking the corresponding pixel of each object's
	// bitmap to see if they're both non-zero:

	for (i = 0; i < over_height; i++) {
		for (j = 0; j < over_width; j++) {
			if (*pixel1 > 0) && (*pixel2 > 0) return(1);
			pixel1++;
			pixel2++;
		}
		pixel1 += (object1->width - over_width);
		pixel2 += (object2->width - over_width);
	}

	// Worst case!  We scanned through the whole darn rectangle of overlap
	// and couldn't find a single colliding pixel!

	return (0);
}*/
/**
 * Displays the win graphic in the center of the screen over the background.
 */
void FightEngine::displayWin()
{
	REG_BG3X = 64;
	REG_BG3Y = 64;
	int win = bgInit(3, BgType_Bmp8, BgSize_B8_128x128, 16,0);
	bgSetPriority(win,0);
	dmaCopy(youWinBitmap, bgGetGfxPtr(win), youWinBitmapLen);
	//dmaCopy(youWinPal, BG_PALETTE, youLosePalLen);
}
/**
 * Displays the lose graphic in the center of the screen over the background.
 */
void FightEngine::displayLose()
{
	oamInit(&oamMain, SpriteMapping_Bmp_1D_128,	false);
	u16* gameOverMem = oamAllocateGfx(&oamMain, SpriteSize_64x32,
			SpriteColorFormat_Bmp);
	//dmaCopy(loseBitmapPal, SPR_PALETTE, loseBitmapPalLen);
	dmaCopy(loseBitmap,gameOverMem,loseBitmapLen);
	oamSet(&oamMain,3,0,0,OBJPRIORITY_0,0,SpriteSize_64x32,
			SpriteColorFormat_Bmp,gameOverMem,0,false,
			false,false,false,false);
}
/**
 * Checks if the game over conditions have been met.
 * @return true if the game is over and false if not
 */
bool FightEngine::gameOver()
{
	if(p1Wins==maxWins)
	{
		displayWin();
		return true;
	}
	if(p2Wins==maxWins)
	{
		displayLose();
		return true;
	}

	return false;
}
/**
 * Actions to perform during VBlank.
 */
void FightEngine::vBlank()
{
	display();
	oamUpdate(&oamMain);
}
/**
 * This is the game loop for the fight engine.  Call this method to start the
 * game loop.
 * @return gameState - the next game state
 */
gameState FightEngine::start()
{
	background->display();
	while(!gameOver())
	{
		handleInput();
		if(!paused)
		{
			playerOne->handleInput();
			playerTwo->handleInput();
			swiWaitForVBlank();
		}
	}
	//iprintf("\nReturning from engine"); //debugging print
	return nextState;
}
/**
 * Destructor for FightEngine.  Deletes the pointers to Characters and
 * the background.
 */
FightEngine::~FightEngine() //Destructor
{
	if(healthDisplay!=NULL)
	{
		delete healthDisplay;
		healthDisplay = NULL;
	}
	if(playerTwo!=NULL)
	{
		delete playerTwo;
		playerTwo = NULL;
	}
	if(playerOne!=NULL)
	{
		delete playerOne;
		playerOne = NULL;
	}
	if(background!=NULL)
	{
		delete background;
		background = NULL;
	}
}
