/* Cursor.h
 * Created on: Mar 6, 2009
 * Author: Ian
 */

/**
 * Using sprites this class will draw a cursor starting at the top
 * left corner.  Cursors can be arrows, boxes, or stars.
 */

#ifndef CURSOR_H_
#define CURSOR_H_

#include "..\gfx\cursors\cursors.h"

class Cursor
{
public:
	enum CursorSize{
		ARROW_8x8, BOX_32x32, BOX_32x64, BOX_64x32, BOX_64x64, STAR_16x16
	};
	Cursor(CursorSize size); //Constructor
	void move(int toX, int toY);
	~Cursor(); //Destructor
private:
	static int cursorCount;
	CursorSize size;
	int posX, posY;
	SpriteSize cursorSize;
	int oamID;
	u16* cursorMem;
	const short unsigned int* cursorTiles;
	unsigned int cursorTilesLen;
	const short unsigned int* cursorPal;
	unsigned int cursorPalLen;

	//inline functions
	int getCursorCount(){return Cursor::cursorCount;}
	void incrCursorCount(){Cursor::cursorCount++;}
	void decrCursorCount(){Cursor::cursorCount--;}
	//end inline functions

	void setSize(CursorSize size);
	void display();
	void initCursor();
};
#endif /* CURSOR_H_ */
