/* Cursor.cpp
 * Created on: Mar 6, 2009
 * Author: Ian
 */

#include <nds.h>

#include <string>  //only used for debug print methods
#include "Cursor.h"

int Cursor::cursorCount = 0; //static class variable

/**
 * None of the pointers are used until setSize is called.
 * @param size - the type of cursor to use
 */
Cursor::Cursor(CursorSize size)
{
	this->cursorTiles = NULL;
	this->cursorPal = NULL;
	this->cursorMem = NULL;
	this->oamID = getCursorCount();
	setSize(size);
	incrCursorCount();
}
/**
 * Sets all of the cursor pointers and sizes to the chosen cursor.
 */
void Cursor::setSize(CursorSize size)
{
	switch(size)
	{
		case ARROW_8x8 :
			this->cursorSize = SpriteSize_8x8;
			this->cursorTiles = arrow8x8Tiles;
			this->cursorTilesLen = arrow8x8TilesLen;
			this->cursorPal = arrow8x8Pal;
			this->cursorPalLen = arrow8x8PalLen;
			break;
		case BOX_32x32 :
			this->cursorSize = SpriteSize_32x32;
			this->cursorTiles = box32x32Tiles;
			this->cursorTilesLen = box32x32TilesLen;
			this->cursorPal = box32x32Pal;
			this->cursorPalLen = box32x32PalLen;
			break;
		case BOX_32x64 :
			this->cursorSize = SpriteSize_32x64;
			this->cursorTiles = box32x64Tiles;
			this->cursorTilesLen = box32x64TilesLen;
			this->cursorPal = box32x64Pal;
			this->cursorPalLen = box32x64PalLen;
			break;
		case BOX_64x32 :
			this->cursorSize = SpriteSize_64x32;
			this->cursorTiles = box64x32Tiles;
			this->cursorTilesLen = box64x32TilesLen;
			this->cursorPal = box64x32Pal;
			this->cursorPalLen = box64x32PalLen;
			break;
		case BOX_64x64 :
			this->cursorSize = SpriteSize_64x64;
			this->cursorTiles = box64x64Tiles;
			this->cursorTilesLen = box64x64TilesLen;
			this->cursorPal = box64x64Pal;
			this->cursorPalLen = box64x64PalLen;
			break;
		case STAR_16x16 :
			this->cursorSize = SpriteSize_16x16;
			this->cursorTiles = star16x16Tiles;
			this->cursorTilesLen = star16x16TilesLen;
			this->cursorPal = star16x16Pal;
			this->cursorPalLen = star16x16PalLen;
			break;
	}
	initCursor();
}
/**
 * Load the cursor into memory.
 */
void Cursor::initCursor()
{
	oamInit(&oamMain, SpriteMapping_1D_128,	false);
	this->cursorMem = oamAllocateGfx(&oamMain, cursorSize,
			SpriteColorFormat_256Color);
	//iprintf("\ncursor %#x",cursorMem);
	dmaCopy(cursorPal, SPRITE_PALETTE, cursorPalLen);
	dmaCopy(cursorTiles, cursorMem, cursorTilesLen);
}
/**
 * Display the cursor in it's current position.
 */
void Cursor::display()
{
	oamSet(&oamMain,oamID,posX,posY,OBJPRIORITY_0,0,cursorSize,
			SpriteColorFormat_256Color,cursorMem,0,false,
			false,false,true,false);
}
/**
 * Move the cursor to the new position and re-display.
 * @param toX - the new 'x' coordinate
 * @param toY - the new 'y' coordinate
 */
void Cursor::move(int toX, int toY)
{
	this->posX = toX;
	this->posY = toY;
	display();
}
/**
 * Clean up the memory that was used.
 */
Cursor::~Cursor()
{
	decrCursorCount();
	oamClear(&oamMain, 0,0);
	oamFreeGfx(&oamMain, cursorMem);
}
