/* Character.h
 * Created on: Mar 8, 2009
 * Author: Ian Roskam
 */

/**
 * Character is used to load a character's stats and sprites.  One of the
 * enumerated 'characters' items is passed to the constructor to determine what
 * character to load.
 */

#ifndef CHARACTER_H_
#define CHARACTER_H_
#include <string> //for strings and prints
#include "../gfx/characters/characters.h"
#include "Sprite.h"
#include "AI.h"

/**
 * A character to diplay on the screen.
 */
class Character{
public:
	//enumeration of all characters
	enum characters{
		AKUMA, CHUNLI, KEN, MAKATO, RYU, SEAN, YANG, YUN, RANDOM
	};
	Character(characters character, bool playerOne);

	//begin inline functions
	const char* getName(){return name;}
	int getHealth(){return health;}
	//end inline functions

	void handleInput();
	void display();
	void hit(int value);
	Sprite sprite;
	~Character(); //Destructor
protected:
	AI* ai;
	const char* name;
	int health;
	int power;
	int speed;
	int defense;
	bool blocking;
	bool playerOne;
	bool idleLoaded;

	//character loading methods
	void loadCharacter(characters character);
	void loadAkuma();
	void loadChunli();
	void loadKen();
	void loadMakato();
	void loadRyu();
	void loadSean();
	void loadYang();
	void loadYun();
	void loadRandom();
	//end character loading methods

	//key handlers
	void handleKeysDown(uint32 keys_down); //what to do when a key is pressed
	void handleKeysHeld(uint32 keys_held); //what to do when a key is held down
	void handleKeysUp(uint32 keys_up); //what to do when a key is released
	//end key handlers

	//basic moves
	void jump();
	void foward();
	void reverse();
	void duck();
	void highPunch();
	void lowPunch();
	void highKick();
	void lowKick();
	void block();
	void toggleBlock();
	//end basic moves

	void idleStance();
};
#endif /* CHARACTER_H_ */
