/* Background.h
 * Created on: Mar 6, 2009
 * Author: Ian
 */

/**
 * Background is used to load a particular background into VRAM.  One of the
 * enumerated bgImage items is passed to the constructor to determine what
 * background to load.  Loading a background will overwrite the current
 * background in VRAM.
 */
#ifndef BACKGROUND_H_
#define BACKGROUND_H_

#include "..\gfx\backgrounds\backgrounds.h" //backround image data

/**
 * All of the methods required to load and display a bitmap background.  The
 * video mode will need to be set explicitly before loading a background.
 * Backgrounds will all be bitmap 256x256.
 */
class Background
{
public:
	//enumeration of all backgrounds available
	enum bgImage{
		AIRFORCE, BALCONY, BEACH, STATUE, STREET, TEMPLE, VEGAS, RANDOM, TITLE,
		CHSELECT, HELP, ABOUT
	};
	Background(bgImage image); //Constructor
	void display(); //load the background and palette into memory
	~Background(); //Destructor
private:
	const unsigned short int* backgroundSrc; //pointer to pixel array
	unsigned int backgroundSrcSize; //size of the pixel array
	const unsigned short int* backgroundPalette; //pointer to palette array
	unsigned int backgroundPaletteSize; //size of the palette array
	int bgID;
	int bgPriority;
	const static int LAYER = 2;
	void random();
	void setImage(bgImage image);
	void initBackground(); //set background variables
};
#endif /* BACKGROUND_H_ */
