import com.ridgesoft.intellibrain.*;
import com.ridgesoft.io.*;
import com.ridgesoft.robotics.*;
import com.ridgesoft.robotics.sensors.DevantechSRF04;


public class RoboSonar implements Runnable
{   private IntelliBrainDigitalIO sonarTrigger;
    private RangeFinder  sonarSensor;
    private float        sonarRange;
    private boolean      on;
    private RoboSerial   serial;
    private RoboDisplay  display;
    
    public RoboSonar (RoboSerial s, RoboDisplay d)
    {   this.sonarTrigger = IntelliBrain.getDigitalIO(1);
        this.sonarTrigger.setDirection(true);
        this.sonarSensor = new DevantechSRF04(this.sonarTrigger, IntelliBrain.getDigitalIO(4));
        this.sonarRange = 0.0f;
        this.on = false;
        this.serial = s;
        this.display = d;
    }

    public float sample ()
    {   try
        {   this.sonarSensor.ping();
            Thread.sleep(53);
            do { this.sonarRange = this.sonarSensor.getDistanceCm(); }
            while ((this.sonarRange < 0.0f));
        }   catch (Throwable t) { t.printStackTrace(); }

        return this.sonarRange;
    }

    public void display ()
    {   this.display.writeTextLine (0, "SONAR:  " + this.sonarRange + "cm");
    }

    private void send ()
    {   this.serial.writeOut (""+'r'+'s'+'i'+'0'+'t'+'0'+'0'+'d'+this.sonarRange+'\r');
    }

    public void toggle ()
    {   this.on = !this.on;
    }

    public boolean isOn ()
    {   return this.on;
    }

    public void run()
    {   while(true)
        {   try
            {   if(this.isOn())
                {    this.sample();
					 this.display();
                     this.send();
                }
            }   catch (Throwable t) { t.printStackTrace(); }
            Thread.yield();
        }
    }
}