import com.ridgesoft.intellibrain.*;
import com.ridgesoft.io.*;

/*  LED CLASS: 1 - STATUS, 2 - FAULT, 3 - INFRARED, 4/5/6/7 - USER1/2/3/4
*/

public class RoboLED implements Runnable
{   private LED[]     led;
    private boolean[] state;

    public RoboLED ()
    {   this.state = new boolean[8];
        for(int i=0; i<this.state.length; ++i)
            this.state[i] = false;

        this.led   = new LED[8];
        this.led[0] = null; // NOT USED
        this.led[1] = IntelliBrain.getStatusLed();
        this.led[2] = IntelliBrain.getFaultLed();
        this.led[3] = IntelliBrain.getIrLed();
        this.led[4] = IntelliBrain.getUserLed(1);
        this.led[5] = IntelliBrain.getUserLed(2);
        this.led[6] = IntelliBrain.getUserLed(3);
        this.led[7] = IntelliBrain.getUserLed(4);
    }

    public void setState (boolean[] b)
    {   for(int i=1; i<this.state.length; ++i)
            state[i] = b[i];
    }

    public void run() 
    {   while(true)
        {   try 
            {   for(int i=1; i<this.state.length; ++i)
				{	if(this.led[i].isOn() != this.state[i]) this.led[i].toggle();
				}
            }   catch (Throwable t) { t.printStackTrace(); }
            Thread.yield();
        }
    }
}