import com.ridgesoft.intellibrain.IntelliBrain;
import javax.comm.*;
import java.io.*;
import com.ridgesoft.io.*;

public class RoboSerial implements Runnable
{   private SerialPort 	 serial;
    private InputStream  inputStream;
	public OutputStream  outputStream;

    //IN AND OUT BUFFERS
    private RoboBuffer   iBuffer;
    private RoboBuffer   oBuffer;
    
	private int          cmdLength;
    private int          lstLength;
    private int          baud;
    private boolean      poll;
    private boolean      echo;

    public RoboSerial ()
    {   this(9600, 25, false, true);
    }

    public RoboSerial (int b, int s, boolean e, boolean p)
    {   this.cmdLength = s;
        this.baud = b;
        this.echo = e;
        this.poll = p;

        try
        {   this.iBuffer = new RoboBuffer();
            this.oBuffer = new RoboBuffer();
            this.serial = IntelliBrain.getCom1();
            this.serial.setSerialPortParams(this.baud, SerialPort.DATABITS_8, SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);
            this.inputStream = this.serial.getInputStream();
            this.outputStream = this.serial.getOutputStream();
        }   catch (Throwable t) { t.printStackTrace(); }
    }

    public String readIn ()
    {   return this.iBuffer.dequeue();
    }

    public String readInOnly ()
    {   return this.iBuffer.getFront();
    }

    public void writeOut (String cmd)
    {   this.oBuffer.enqueue(cmd);
    }

    //READER FILLS THE IN BUFFER WITH COMMANDS THAT YOU CAN PULL OUT
    private int read ()
    {   byte[] cmd = new byte[this.cmdLength];
 
        int dataByte = 0;
        int countByte = 0;

        try
        {  	//IF INPUT STREAM CONTAINS DATA
			if((dataByte = this.inputStream.read()) != -1)
            {   //WHILE THERE'S STILL DATA
				while ((dataByte = this.inputStream.read()) != -1)
                {   //DISCARD PREAMBLE
					if ((char)dataByte == (char)0) continue;
					//WHILE WE'RE STILL WITHIN THE BOUNDS OF A SINGLE COMMAND
                    if (countByte < cmd.length)
                    {   //ADD BYTE TO THE COMMAND AS A BYTE
                        cmd[countByte++] = (byte)dataByte;
                        //IF THIS BYTE IS CR/LF, COMMAND IS COMPLETE
                        if ((char)dataByte == '\r' || (char)dataByte == '\n')
                        {   //WRITE COMMAND TO THE BUFFER
                            this.iBuffer.enqueue(new String(cmd));
							//ACK COMMAND BY RETURNING SIZE OF THE COMMAND
                            if (this.echo)
                            {   byte[] ack = new byte[2];
                                ack[0] = (byte)countByte;
                                ack[1] = '\r';
                                this.outputStream.write(ack);
                            }

                            return countByte;
        }   }   }   }   }
        catch (Exception e)
        {   e.printStackTrace();
		}
		return -1;
	}

    private void write ()
    {   if (!this.oBuffer.isEmpty())
		{	byte[] cmd	  = this.oBuffer.dequeue().getBytes();
			//IntelliBrain.getLcdDisplay().print(0, "SERIAL");
			//IntelliBrain.getLcdDisplay().print(1, cmd);
			byte[] newcmd = new byte[cmd.length+2];
        
            try
			{   //ADD PREAMBLE
            	for (int i=0; i<2; ++i)
                	newcmd[i] = (byte)0;
            	//ADD MESSAGE
           		for (int i=0; i<cmd.length; ++i)
                	newcmd[i+2] = cmd[i];
				//ADD TERMINATOR
				for (int i=0; i<1; ++i)
                	newcmd[newcmd.length-1] = '\r';
            	//SEND OUT
        		this.outputStream.write(newcmd);
			}	catch (Exception e) { e.printStackTrace(); }	
		}
	}

    public void run()
    {   while (true)
        {   try
        	{ 	this.write();
				this.read();
 	           	//Thread.yield();
				Thread.sleep(50);
        	}   catch (Throwable t) {t.printStackTrace();}
        }
    }

    public boolean isEcho()
    {   return echo;
    }

    public void setEcho(boolean echo)
    {   this.echo = echo;
    }

    public boolean isPoll()
    {   return poll;
    }

    public void setPoll(boolean poll)
    {   this.poll = poll;
    }

    public int getBaud()
    {   return baud;
    }

	public SerialPort getSerial ()
	{	return this.serial;
	}

    public int getCommandLength()
    {   return this.cmdLength;
    }
}