import com.ridgesoft.intellibrain.*;
import com.ridgesoft.io.*;
import com.ridgesoft.robotics.*;
import com.ridgesoft.robotics.sensors.SharpGP2D12;

/* Sharp GP2D12 INFRARED SENSOR
 * RANGE: 10-80 CM
 * SAMPLING RATE: 38.3MS+/-9.6MS
 * PROCESSING RATE: 5MS MAX
*/

public class RoboInfrared implements Runnable
{   private RangeFinder[]  light;
    private float[]      range;
    private boolean      on;
    private int          samplingRate;
    private RoboSerial   serial;
    private RoboDisplay  display;

    public RoboInfrared (RoboSerial s, RoboDisplay d)
    {   this.light = new RangeFinder[2];
		this.light[1] = new SharpGP2D12(IntelliBrain.getAnalogInput(2), null);
        this.light[0] = new SharpGP2D12(IntelliBrain.getAnalogInput(1), null);
        this.range = new float[2]; this.range[0] = 0.0f; this.range[1] = 0.0f;
        this.on = false;
        this.samplingRate = 53;
        this.serial = s;
        this.display = d;
    }

	public void sample()
    {	this.sample(0);
		this.sample(1);
	}                

    public float sample (int i)
    {   try
        {   do
			{	this.light[i].ping();
            	//SLEEP DURING SAMPLING AND CALCULATION
            	Thread.sleep(53);
            	this.range[i] = this.light[i].getDistanceCm();
            }   while (this.range[i] < 0.0f);

            //OUT OF RANGE CHECK
            if (this.range[i]  < 0.0f) this.range[i] = 99;
        }   catch (Throwable t) { t.printStackTrace(); }

        return this.range[i]+0.5f;
    }

    public void display ()
    {   if (this.range[0] > 0.0f && this.range[1] > 0.0f)
        {   this.display.writeTextLine (0, "LEFT:  "+this.range[0]+" cm");
            this.display.writeTextLine (1, "RIGHT: "+this.range[1]+" cm");
    }   }

    private void send ()
    {   this.serial.writeOut ("rii0t00d"+this.range[0]+'\r');
        this.serial.writeOut ("rii1t00d"+this.range[1]+'\r');
    }

    public void toggle ()
    {   this.on = !this.on;
    }

    public boolean isOn ()
    {   return this.on;
    }

    public void run()
    {	try
		{	while(true)
            {   if(this.isOn())
                {   this.sample();
                    this.display();
					this.send();		
                }
				Thread.sleep(50);
	            //Thread.yield();
			}
      	}   catch (Throwable t) { t.printStackTrace(); }
    }
}